import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare const stableVersionRegex: RegExp;
export declare class FlutterVersionDatasource extends Datasource {
    static readonly id = "flutter-version";
    constructor();
    readonly customRegistrySupport = false;
    readonly defaultRegistryUrls: string[];
    readonly caching = true;
    readonly defaultVersioning = "semver";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `release_date` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "We use the URL: https://github.com/flutter/flutter.";
    getReleases({ registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
