import { DateTime } from 'luxon';
import { z } from 'zod';
import type { Release } from '../types';
export declare const EndoflifeDateVersions: z.ZodArray<z.ZodEffects<z.ZodObject<{
    cycle: z.ZodString;
    latest: z.ZodOptional<z.ZodString>;
    releaseDate: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodUnknown, import("../../../util/timestamp").Timestamp, unknown>>>;
    eol: z.ZodOptional<z.ZodUnion<[z.ZodEffects<z.ZodEffects<z.ZodString, DateTime<boolean>, string>, boolean, string>, z.ZodBoolean]>>;
    discontinued: z.ZodOptional<z.ZodUnion<[z.ZodEffects<z.ZodEffects<z.ZodString, DateTime<boolean>, string>, boolean, string>, z.ZodBoolean]>>;
}, "strip", z.ZodTypeAny, {
    cycle: string;
    releaseDate: import("../../../util/timestamp").Timestamp | null;
    latest?: string | undefined;
    eol?: boolean | undefined;
    discontinued?: boolean | undefined;
}, {
    cycle: string;
    latest?: string | undefined;
    releaseDate?: unknown;
    eol?: string | boolean | undefined;
    discontinued?: string | boolean | undefined;
}>, Release, {
    cycle: string;
    latest?: string | undefined;
    releaseDate?: unknown;
    eol?: string | boolean | undefined;
    discontinued?: string | boolean | undefined;
}>, "many">;
