"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndoflifeDateDatasource = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const decorator_1 = require("../../../util/cache/package/decorator");
const url_1 = require("../../../util/url");
const datasource_1 = require("../datasource");
const common_1 = require("./common");
const schema_1 = require("./schema");
class EndoflifeDateDatasource extends datasource_1.Datasource {
    static id = common_1.datasource;
    defaultRegistryUrls = [common_1.registryUrl];
    caching = true;
    defaultVersioning = 'loose';
    releaseTimestampSupport = true;
    releaseTimestampNote = 'The release timestamp is determined from the `releaseDate` field in the results.';
    constructor() {
        super(EndoflifeDateDatasource.id);
    }
    async getReleases({ registryUrl, packageName, }) {
        if (!is_1.default.nonEmptyString(registryUrl)) {
            return null;
        }
        logger_1.logger.trace(`${common_1.datasource}.getReleases(${registryUrl}, ${packageName})`);
        const result = {
            releases: [],
        };
        const url = (0, url_1.joinUrlParts)(registryUrl, `${packageName}.json`);
        try {
            const response = await this.http.getJson(url, schema_1.EndoflifeDateVersions);
            result.releases.push(...response.body);
            return result.releases.length ? result : null;
        }
        catch (err) {
            this.handleGenericErrors(err);
        }
    }
}
exports.EndoflifeDateDatasource = EndoflifeDateDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${common_1.datasource}`,
        key: ({ registryUrl, packageName }) => 
        // TODO: types (#22198)
        `${registryUrl}:${packageName}`,
    })
], EndoflifeDateDatasource.prototype, "getReleases", null);
//# sourceMappingURL=index.js.map