import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class EndoflifeDateDatasource extends Datasource {
    static readonly id = "endoflife-date";
    readonly defaultRegistryUrls: string[];
    readonly caching = true;
    readonly defaultVersioning = "loose";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `releaseDate` field in the results.";
    constructor();
    getReleases({ registryUrl, packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
