import { Datasource } from '../datasource';
import type { GetReleasesConfig, Release, ReleaseResult } from '../types';
export declare class DotnetVersionDatasource extends Datasource {
    static readonly id = "dotnet-version";
    constructor();
    readonly caching = true;
    readonly customRegistrySupport = false;
    readonly defaultRegistryUrls: string[];
    releaseTimestampSupport: boolean;
    releaseTimestampNote: string;
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "We use the URL https://github.com/dotnet/sdk for the `dotnet-sdk` package and, the https://github.com/dotnet/runtime URL for the `dotnet-runtime` package.";
    getReleases({ packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    getChannelReleases(releaseUrl: string, packageName: string): Promise<Release[]>;
}
