import { z } from 'zod';
/**
 *  OCI manifest object
 */
export declare const ManifestObject: z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
    mediaType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    schemaVersion: 2;
    mediaType?: string | null | undefined;
}, {
    schemaVersion: 2;
    mediaType?: string | null | undefined;
}>;
/**
 * Oci descriptor
 * https://github.com/opencontainers/image-spec/blob/main/descriptor.md
 */
export declare const Descriptor: z.ZodObject<{
    mediaType: z.ZodString;
    digest: z.ZodString;
    size: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    digest: string;
    mediaType: string;
    size?: number | null | undefined;
}, {
    digest: string;
    mediaType: string;
    size?: number | null | undefined;
}>;
/**
 * OCI Image Configuration.
 *
 * Compatible with old docker configiguration.
 * https://github.com/opencontainers/image-spec/blob/main/config.md
 */
export declare const OciImageConfig: z.ZodObject<{
    architecture: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    config: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        Labels: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodString>>>;
    }, "strip", z.ZodTypeAny, {
        Labels?: Record<string, string> | null | undefined;
    }, {
        Labels?: Record<string, string> | null | undefined;
    }>>>;
}, "strip", z.ZodTypeAny, {
    config?: {
        Labels?: Record<string, string> | null | undefined;
    } | null | undefined;
    architecture?: string | null | undefined;
}, {
    config?: {
        Labels?: Record<string, string> | null | undefined;
    } | null | undefined;
    architecture?: string | null | undefined;
}>;
export type OciImageConfig = z.infer<typeof OciImageConfig>;
/**
 * OCI Helm Configuration
 * https://helm.sh/docs/topics/charts/#the-chartyaml-file
 */
export declare const OciHelmConfig: z.ZodObject<{
    name: z.ZodString;
    version: z.ZodString;
    home: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    sources: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodString, "many">>>;
}, "strip", z.ZodTypeAny, {
    name: string;
    version: string;
    home?: string | null | undefined;
    sources?: string[] | null | undefined;
}, {
    name: string;
    version: string;
    home?: string | null | undefined;
    sources?: string[] | null | undefined;
}>;
export type OciHelmConfig = z.infer<typeof OciHelmConfig>;
/**
 * OCI Image Manifest
 * The same structure as docker image manifest, but mediaType is not required and is not present in the wild.
 * https://github.com/opencontainers/image-spec/blob/main/manifest.md
 */
export declare const OciImageManifest: z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.oci.image.manifest.v1+json">;
    config: z.ZodObject<{
        digest: z.ZodString;
        size: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
    } & {
        mediaType: z.ZodEnum<["application/vnd.oci.image.config.v1+json", "application/vnd.cncf.helm.config.v1+json", "application/vnd.devcontainers", "application/vnd.oci.empty.v1+json", "application/vnd.cncf.flux.config.v1+json"]>;
    }, "strip", z.ZodTypeAny, {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    }, {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    }>;
    annotations: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodString>>>;
}, "strip", z.ZodTypeAny, {
    config: {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.manifest.v1+json";
    annotations?: Record<string, string> | null | undefined;
}, {
    config: {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.manifest.v1+json";
    annotations?: Record<string, string> | null | undefined;
}>;
export type OciImageManifest = z.infer<typeof OciImageManifest>;
/**
 * OCI Image List
 * mediaType is not required.
 * https://github.com/opencontainers/image-spec/blob/main/image-index.md
 */
export declare const OciImageIndexManifest: z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.oci.image.index.v1+json">;
    manifests: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        digest: string;
        mediaType: "application/vnd.oci.image.manifest.v1+json" | "application/vnd.oci.image.index.v1+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[], any[]>;
    annotations: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodString>>>;
}, "strip", z.ZodTypeAny, {
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.index.v1+json";
    manifests: {
        digest: string;
        mediaType: "application/vnd.oci.image.manifest.v1+json" | "application/vnd.oci.image.index.v1+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[];
    annotations?: Record<string, string> | null | undefined;
}, {
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.index.v1+json";
    manifests: any[];
    annotations?: Record<string, string> | null | undefined;
}>;
/**
 * Image Manifest
 * https://docs.docker.com/registry/spec/manifest-v2-2/#image-manifest
 */
export declare const DistributionManifest: z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.docker.distribution.manifest.v2+json">;
    config: z.ZodObject<{
        digest: z.ZodString;
        size: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
    } & {
        mediaType: z.ZodLiteral<"application/vnd.docker.container.image.v1+json">;
    }, "strip", z.ZodTypeAny, {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    }, {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    config: {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.v2+json";
}, {
    config: {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.v2+json";
}>;
export type DistributionManifest = z.infer<typeof DistributionManifest>;
/**
 * Manifest List
 * https://docs.docker.com/registry/spec/manifest-v2-2/#manifest-list
 */
export declare const DistributionListManifest: z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.docker.distribution.manifest.list.v2+json">;
    manifests: z.ZodArray<z.ZodObject<{
        digest: z.ZodString;
        size: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
    } & {
        mediaType: z.ZodLiteral<"application/vnd.docker.distribution.manifest.v2+json">;
        platform: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            architecture: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            architecture?: string | null | undefined;
        }, {
            architecture?: string | null | undefined;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }, {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.list.v2+json";
    manifests: {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[];
}, {
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.list.v2+json";
    manifests: {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[];
}>;
export declare const Manifest: z.ZodPipeline<z.ZodEffects<z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
    mediaType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    schemaVersion: z.ZodLiteral<2>;
    mediaType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    schemaVersion: z.ZodLiteral<2>;
    mediaType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.ZodTypeAny, "passthrough">>, z.objectOutputType<{
    schemaVersion: z.ZodLiteral<2>;
    mediaType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    schemaVersion: z.ZodLiteral<2>;
    mediaType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.ZodTypeAny, "passthrough">>, z.ZodDiscriminatedUnion<"mediaType", [z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.docker.distribution.manifest.v2+json">;
    config: z.ZodObject<{
        digest: z.ZodString;
        size: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
    } & {
        mediaType: z.ZodLiteral<"application/vnd.docker.container.image.v1+json">;
    }, "strip", z.ZodTypeAny, {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    }, {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    config: {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.v2+json";
}, {
    config: {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.v2+json";
}>, z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.docker.distribution.manifest.list.v2+json">;
    manifests: z.ZodArray<z.ZodObject<{
        digest: z.ZodString;
        size: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
    } & {
        mediaType: z.ZodLiteral<"application/vnd.docker.distribution.manifest.v2+json">;
        platform: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            architecture: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            architecture?: string | null | undefined;
        }, {
            architecture?: string | null | undefined;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }, {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.list.v2+json";
    manifests: {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[];
}, {
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.list.v2+json";
    manifests: {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[];
}>, z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.oci.image.manifest.v1+json">;
    config: z.ZodObject<{
        digest: z.ZodString;
        size: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
    } & {
        mediaType: z.ZodEnum<["application/vnd.oci.image.config.v1+json", "application/vnd.cncf.helm.config.v1+json", "application/vnd.devcontainers", "application/vnd.oci.empty.v1+json", "application/vnd.cncf.flux.config.v1+json"]>;
    }, "strip", z.ZodTypeAny, {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    }, {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    }>;
    annotations: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodString>>>;
}, "strip", z.ZodTypeAny, {
    config: {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.manifest.v1+json";
    annotations?: Record<string, string> | null | undefined;
}, {
    config: {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.manifest.v1+json";
    annotations?: Record<string, string> | null | undefined;
}>, z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.oci.image.index.v1+json">;
    manifests: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        digest: string;
        mediaType: "application/vnd.oci.image.manifest.v1+json" | "application/vnd.oci.image.index.v1+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[], any[]>;
    annotations: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodString>>>;
}, "strip", z.ZodTypeAny, {
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.index.v1+json";
    manifests: {
        digest: string;
        mediaType: "application/vnd.oci.image.manifest.v1+json" | "application/vnd.oci.image.index.v1+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[];
    annotations?: Record<string, string> | null | undefined;
}, {
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.index.v1+json";
    manifests: any[];
    annotations?: Record<string, string> | null | undefined;
}>]>>;
export type Manifest = z.infer<typeof Manifest>;
export declare const ManifestJson: z.ZodPipeline<z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>, z.ZodPipeline<z.ZodEffects<z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
    mediaType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    schemaVersion: z.ZodLiteral<2>;
    mediaType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    schemaVersion: z.ZodLiteral<2>;
    mediaType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.ZodTypeAny, "passthrough">>, z.objectOutputType<{
    schemaVersion: z.ZodLiteral<2>;
    mediaType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    schemaVersion: z.ZodLiteral<2>;
    mediaType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.ZodTypeAny, "passthrough">>, z.ZodDiscriminatedUnion<"mediaType", [z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.docker.distribution.manifest.v2+json">;
    config: z.ZodObject<{
        digest: z.ZodString;
        size: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
    } & {
        mediaType: z.ZodLiteral<"application/vnd.docker.container.image.v1+json">;
    }, "strip", z.ZodTypeAny, {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    }, {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    config: {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.v2+json";
}, {
    config: {
        digest: string;
        mediaType: "application/vnd.docker.container.image.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.v2+json";
}>, z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.docker.distribution.manifest.list.v2+json">;
    manifests: z.ZodArray<z.ZodObject<{
        digest: z.ZodString;
        size: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
    } & {
        mediaType: z.ZodLiteral<"application/vnd.docker.distribution.manifest.v2+json">;
        platform: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            architecture: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            architecture?: string | null | undefined;
        }, {
            architecture?: string | null | undefined;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }, {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.list.v2+json";
    manifests: {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[];
}, {
    schemaVersion: 2;
    mediaType: "application/vnd.docker.distribution.manifest.list.v2+json";
    manifests: {
        digest: string;
        mediaType: "application/vnd.docker.distribution.manifest.v2+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[];
}>, z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.oci.image.manifest.v1+json">;
    config: z.ZodObject<{
        digest: z.ZodString;
        size: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
    } & {
        mediaType: z.ZodEnum<["application/vnd.oci.image.config.v1+json", "application/vnd.cncf.helm.config.v1+json", "application/vnd.devcontainers", "application/vnd.oci.empty.v1+json", "application/vnd.cncf.flux.config.v1+json"]>;
    }, "strip", z.ZodTypeAny, {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    }, {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    }>;
    annotations: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodString>>>;
}, "strip", z.ZodTypeAny, {
    config: {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.manifest.v1+json";
    annotations?: Record<string, string> | null | undefined;
}, {
    config: {
        digest: string;
        mediaType: "application/vnd.oci.image.config.v1+json" | "application/vnd.cncf.helm.config.v1+json" | "application/vnd.devcontainers" | "application/vnd.oci.empty.v1+json" | "application/vnd.cncf.flux.config.v1+json";
        size?: number | null | undefined;
    };
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.manifest.v1+json";
    annotations?: Record<string, string> | null | undefined;
}>, z.ZodObject<{
    schemaVersion: z.ZodLiteral<2>;
} & {
    mediaType: z.ZodLiteral<"application/vnd.oci.image.index.v1+json">;
    manifests: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        digest: string;
        mediaType: "application/vnd.oci.image.manifest.v1+json" | "application/vnd.oci.image.index.v1+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[], any[]>;
    annotations: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodString>>>;
}, "strip", z.ZodTypeAny, {
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.index.v1+json";
    manifests: {
        digest: string;
        mediaType: "application/vnd.oci.image.manifest.v1+json" | "application/vnd.oci.image.index.v1+json";
        platform?: {
            architecture?: string | null | undefined;
        } | null | undefined;
        size?: number | null | undefined;
    }[];
    annotations?: Record<string, string> | null | undefined;
}, {
    schemaVersion: 2;
    mediaType: "application/vnd.oci.image.index.v1+json";
    manifests: any[];
    annotations?: Record<string, string> | null | undefined;
}>]>>>;
export declare const DockerHubTag: z.ZodObject<{
    id: z.ZodNumber;
    last_updated: z.ZodString;
    name: z.ZodString;
    tag_last_pushed: z.ZodCatch<z.ZodNullable<z.ZodString>>;
    digest: z.ZodCatch<z.ZodNullable<z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    id: number;
    digest: string | null;
    name: string;
    last_updated: string;
    tag_last_pushed: string | null;
}, {
    id: number;
    name: string;
    last_updated: string;
    digest?: unknown;
    tag_last_pushed?: unknown;
}>;
export type DockerHubTag = z.infer<typeof DockerHubTag>;
export declare const DockerHubTagsPage: z.ZodObject<{
    count: z.ZodNumber;
    next: z.ZodCatch<z.ZodNullable<z.ZodString>>;
    results: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        id: number;
        digest: string | null;
        name: string;
        last_updated: string;
        tag_last_pushed: string | null;
    }[], any[]>;
}, "strip", z.ZodTypeAny, {
    count: number;
    next: string | null;
    results: {
        id: number;
        digest: string | null;
        name: string;
        last_updated: string;
        tag_last_pushed: string | null;
    }[];
}, {
    count: number;
    results: any[];
    next?: unknown;
}>;
