import type { HttpResponse } from '../../../util/http/types';
import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, Release, ReleaseResult } from '../types';
import { OciHelmConfig, OciImageConfig } from './schema';
export declare class DockerDatasource extends Datasource {
    static readonly id = "docker";
    readonly defaultVersioning = "docker";
    readonly defaultRegistryUrls: string[];
    readonly defaultConfig: {
        commitMessageTopic: string;
        commitMessageExtra: string;
        digest: {
            branchTopic: string;
            commitMessageExtra: string;
            commitMessageTopic: string;
            group: {
                commitMessageTopic: string;
                commitMessageExtra: string;
            };
        };
        pin: {
            commitMessageExtra: string;
            groupName: string;
            group: {
                commitMessageTopic: string;
                branchTopic: string;
            };
        };
    };
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `tag_last_pushed` field in the results.";
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined from the `org.opencontainers.image.source` and `org.label-schema.vcs-url` labels present in the metadata of the **latest stable** image found on the Docker registry.";
    constructor();
    private getManifestResponse;
    getImageConfig(registryHost: string, dockerRepository: string, configDigest: string): Promise<HttpResponse<OciImageConfig> | undefined>;
    getHelmConfig(registryHost: string, dockerRepository: string, configDigest: string): Promise<HttpResponse<OciHelmConfig> | undefined>;
    private getConfigDigest;
    private getManifest;
    getImageArchitecture(registryHost: string, dockerRepository: string, currentDigest: string): Promise<string | null | undefined>;
    getLabels(registryHost: string, dockerRepository: string, tag: string): Promise<Record<string, string> | undefined>;
    private getTagsQuayRegistry;
    private getDockerApiTags;
    getTags(registryHost: string, dockerRepository: string): Promise<string[] | null>;
    /**
     * docker.getDigest
     *
     * The `newValue` supplied here should be a valid tag for the docker image.
     *
     * This function will:
     *  - Look up a sha256 digest for a tag on its registry
     *  - Return the digest as a string
     */
    getDigest({ registryUrl, lookupName, packageName, currentDigest }: DigestConfig, newValue?: string): Promise<string | null>;
    getDockerHubTags(dockerRepository: string): Promise<Release[] | null>;
    /**
     * docker.getReleases
     *
     * A docker image usually looks something like this: somehost.io/owner/repo:8.1.0-alpine
     * In the above:
     *  - 'somehost.io' is the registry
     *  - 'owner/repo' is the package name
     *  - '8.1.0-alpine' is the tag
     *
     * This function will filter only tags that contain a semver version
     */
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
