import type { DockerHubTag } from './schema';
export interface DockerHubCacheData {
    items: Record<number, DockerHubTag>;
    updatedAt: string | null;
}
export declare class DockerHubCache {
    private dockerRepository;
    private cache;
    private isChanged;
    private reconciledIds;
    private constructor();
    static init(dockerRepository: string): Promise<DockerHubCache>;
    reconcile(items: DockerHubTag[], expectedCount: number): boolean;
    save(): Promise<void>;
    getItems(): DockerHubTag[];
}
