"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevboxDatasource = void 0;
const tslib_1 = require("tslib");
const logger_1 = require("../../../logger");
const external_host_error_1 = require("../../../types/errors/external-host-error");
const http_1 = require("../../../util/http");
const url_1 = require("../../../util/url");
const devboxVersioning = tslib_1.__importStar(require("../../versioning/devbox"));
const datasource_1 = require("../datasource");
const common_1 = require("./common");
const schema_1 = require("./schema");
class DevboxDatasource extends datasource_1.Datasource {
    static id = common_1.datasource;
    constructor() {
        super(common_1.datasource);
    }
    customRegistrySupport = true;
    releaseTimestampSupport = true;
    registryStrategy = 'first';
    defaultVersioning = devboxVersioning.id;
    defaultRegistryUrls = [common_1.defaultRegistryUrl];
    async getReleases({ registryUrl, packageName, }) {
        const res = {
            releases: [],
        };
        logger_1.logger.trace({ registryUrl, packageName }, 'fetching devbox release');
        const devboxPkgUrl = (0, url_1.joinUrlParts)(registryUrl, `/pkg?name=${encodeURIComponent(packageName)}`);
        try {
            const response = await this.http.getJson(devboxPkgUrl, schema_1.DevboxResponse);
            res.releases = response.body.releases;
            res.homepage = response.body.homepage;
        }
        catch (err) {
            if (err instanceof http_1.HttpError) {
                if (err.response?.statusCode !== 404) {
                    throw new external_host_error_1.ExternalHostError(err);
                }
            }
            this.handleGenericErrors(err);
        }
        return res.releases.length ? res : null;
    }
}
exports.DevboxDatasource = DevboxDatasource;
//# sourceMappingURL=index.js.map