import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class DenoDatasource extends Datasource {
    static readonly id = "deno";
    readonly customRegistrySupport = true;
    readonly registryStrategy = "first";
    readonly defaultVersioning = "semver";
    readonly defaultRegistryUrls: string[];
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `uploaded_at` field in the results.";
    readonly sourceUrlSupport = "release";
    readonly sourceUrlNote = "The source URL is determined from the `repository` field in the results.";
    constructor();
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    getReleaseResult(moduleAPIURL: string): Promise<ReleaseResult>;
}
