/**
 * Extracts the base suite URL from a package URL by removing the last two path segments.
 *
 * @param basePackageUrl - The base URL of the package.
 * @returns The base suite URL.
 *
 * @example
 * // Returns 'https://deb.debian.org/debian/dists/bullseye'
 * getBaseReleaseUrl('https://deb.debian.org/debian/dists/bullseye/main/binary-amd64');
 */
export declare function getBaseSuiteUrl(basePackageUrl: string): string;
/**
 * Constructs the component URLs from the given registry URL.
 *
 * @param registryUrl - The base URL of the registry.
 * @returns An array of component URLs.
 * @throws Will throw an error if required parameters are missing from the URL.
 */
export declare function constructComponentUrls(registryUrl: string): string[];
