"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extract = extract;
exports.getFileCreationTime = getFileCreationTime;
const tslib_1 = require("tslib");
const zlib_1 = require("zlib");
const fs = tslib_1.__importStar(require("../../../util/fs"));
/**
 * Extracts the specified compressed file to the output file.
 *
 * @param compressedFile - The path to the compressed file.
 * @param compression - The compression method used (currently only 'gz' is supported).
 * @param outputFile - The path where the extracted content will be stored.
 * @throws Will throw an error if the compression method is unknown.
 */
async function extract(compressedFile, compression, outputFile) {
    if (compression === 'gz') {
        const source = fs.createCacheReadStream(compressedFile);
        const destination = fs.createCacheWriteStream(outputFile);
        await fs.pipeline(source, (0, zlib_1.createUnzip)(), destination);
    }
    else {
        throw new Error(`Unsupported compression standard '${compression}'`);
    }
}
/**
 * Checks if the file exists and retrieves its creation time.
 *
 * @param filePath - The path to the file.
 * @returns The creation time if the file exists, otherwise undefined.
 */
async function getFileCreationTime(filePath) {
    const stats = await fs.statCacheFile(filePath);
    return stats?.ctime;
}
//# sourceMappingURL=file.js.map