"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Datasource = void 0;
const external_host_error_1 = require("../../types/errors/external-host-error");
const http_1 = require("../../util/http");
class Datasource {
    id;
    constructor(id) {
        this.id = id;
        this.http = new http_1.Http(id);
    }
    caching;
    customRegistrySupport = true;
    defaultConfig;
    defaultRegistryUrls;
    defaultVersioning;
    registryStrategy = 'first';
    releaseTimestampSupport = false;
    releaseTimestampNote;
    sourceUrlSupport = 'none';
    sourceUrlNote;
    http;
    handleHttpErrors(_err) {
        // intentionally empty
    }
    handleGenericErrors(err) {
        if (err instanceof external_host_error_1.ExternalHostError) {
            throw err;
        }
        if (err instanceof http_1.HttpError) {
            this.handleHttpErrors(err);
            const statusCode = err.response?.statusCode;
            if (statusCode) {
                if (statusCode === 429 || (statusCode >= 500 && statusCode < 600)) {
                    throw new external_host_error_1.ExternalHostError(err);
                }
            }
        }
        throw err;
    }
    // istanbul ignore next: no-op implementation, never called
    postprocessRelease(_config, release) {
        return Promise.resolve(release);
    }
}
exports.Datasource = Datasource;
//# sourceMappingURL=datasource.js.map