"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DartDatasource = void 0;
const timestamp_1 = require("../../../util/timestamp");
const url_1 = require("../../../util/url");
const datasource_1 = require("../datasource");
class DartDatasource extends datasource_1.Datasource {
    static id = 'dart';
    constructor() {
        super(DartDatasource.id);
    }
    customRegistrySupport = true;
    defaultRegistryUrls = ['https://pub.dartlang.org/'];
    releaseTimestampSupport = true;
    releaseTimestampNote = 'The release timestamp is determined from the `published` field in the results.';
    sourceUrlSupport = 'package';
    sourceUrlNote = 'The source URL is determined from the `repository` field of the latest release object in the results.';
    async getReleases({ packageName, registryUrl, }) {
        /* v8 ignore next 3 -- should never happen */
        if (!registryUrl) {
            return null;
        }
        let result = null;
        const pkgUrl = `${(0, url_1.ensureTrailingSlash)(registryUrl)}api/packages/${packageName}`;
        let raw = null;
        try {
            raw = await this.http.getJsonUnchecked(pkgUrl);
        }
        catch (err) {
            this.handleGenericErrors(err);
        }
        const body = raw?.body;
        if (body) {
            const { versions, latest } = body;
            const releases = versions
                ?.filter(({ retracted }) => !retracted)
                ?.map(({ version, published }) => ({
                version,
                releaseTimestamp: (0, timestamp_1.asTimestamp)(published),
            }));
            if (releases && latest) {
                result = { releases };
                const pubspec = latest.pubspec;
                if (pubspec) {
                    if (pubspec.homepage) {
                        result.homepage = pubspec.homepage;
                    }
                    if (pubspec.repository) {
                        result.sourceUrl = pubspec.repository;
                    }
                }
            }
        }
        return result;
    }
}
exports.DartDatasource = DartDatasource;
//# sourceMappingURL=index.js.map