"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReleaseResultZodSchema = void 0;
const zod_1 = require("zod");
const timestamp_1 = require("../../../util/timestamp");
exports.ReleaseResultZodSchema = zod_1.z.object({
    releases: zod_1.z.array(zod_1.z
        .object({
        version: zod_1.z.string(),
        isDeprecated: zod_1.z.boolean().optional(),
        releaseTimestamp: timestamp_1.MaybeTimestamp,
        sourceUrl: zod_1.z.string().optional(),
        sourceDirectory: zod_1.z.string().optional(),
        changelogUrl: zod_1.z.string().optional(),
        digest: zod_1.z.string().optional(),
        isStable: zod_1.z.boolean().optional(),
    })
        .transform((input) => {
        return {
            ...input,
            newDigest: input.digest,
            digest: undefined,
        };
    })),
    tags: zod_1.z.record(zod_1.z.string(), zod_1.z.string()).optional(),
    sourceUrl: zod_1.z.string().optional(),
    sourceDirectory: zod_1.z.string().optional(),
    changelogUrl: zod_1.z.string().optional(),
    homepage: zod_1.z.string().optional(),
});
//# sourceMappingURL=schema.js.map