import { z } from 'zod';
export declare const ReleaseResultZodSchema: z.ZodObject<{
    releases: z.ZodArray<z.ZodEffects<z.ZodObject<{
        version: z.ZodString;
        isDeprecated: z.ZodOptional<z.ZodBoolean>;
        releaseTimestamp: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodUnknown, import("../../../util/timestamp").Timestamp, unknown>>>;
        sourceUrl: z.ZodOptional<z.ZodString>;
        sourceDirectory: z.ZodOptional<z.ZodString>;
        changelogUrl: z.ZodOptional<z.ZodString>;
        digest: z.ZodOptional<z.ZodString>;
        isStable: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        version: string;
        releaseTimestamp: import("../../../util/timestamp").Timestamp | null;
        digest?: string | undefined;
        isStable?: boolean | undefined;
        changelogUrl?: string | undefined;
        sourceUrl?: string | undefined;
        sourceDirectory?: string | undefined;
        isDeprecated?: boolean | undefined;
    }, {
        version: string;
        digest?: string | undefined;
        isStable?: boolean | undefined;
        changelogUrl?: string | undefined;
        sourceUrl?: string | undefined;
        sourceDirectory?: string | undefined;
        isDeprecated?: boolean | undefined;
        releaseTimestamp?: unknown;
    }>, {
        newDigest: string | undefined;
        digest: undefined;
        version: string;
        releaseTimestamp: import("../../../util/timestamp").Timestamp | null;
        isStable?: boolean | undefined;
        changelogUrl?: string | undefined;
        sourceUrl?: string | undefined;
        sourceDirectory?: string | undefined;
        isDeprecated?: boolean | undefined;
    }, {
        version: string;
        digest?: string | undefined;
        isStable?: boolean | undefined;
        changelogUrl?: string | undefined;
        sourceUrl?: string | undefined;
        sourceDirectory?: string | undefined;
        isDeprecated?: boolean | undefined;
        releaseTimestamp?: unknown;
    }>, "many">;
    tags: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    sourceUrl: z.ZodOptional<z.ZodString>;
    sourceDirectory: z.ZodOptional<z.ZodString>;
    changelogUrl: z.ZodOptional<z.ZodString>;
    homepage: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    releases: {
        newDigest: string | undefined;
        digest: undefined;
        version: string;
        releaseTimestamp: import("../../../util/timestamp").Timestamp | null;
        isStable?: boolean | undefined;
        changelogUrl?: string | undefined;
        sourceUrl?: string | undefined;
        sourceDirectory?: string | undefined;
        isDeprecated?: boolean | undefined;
    }[];
    tags?: Record<string, string> | undefined;
    homepage?: string | undefined;
    changelogUrl?: string | undefined;
    sourceUrl?: string | undefined;
    sourceDirectory?: string | undefined;
}, {
    releases: {
        version: string;
        digest?: string | undefined;
        isStable?: boolean | undefined;
        changelogUrl?: string | undefined;
        sourceUrl?: string | undefined;
        sourceDirectory?: string | undefined;
        isDeprecated?: boolean | undefined;
        releaseTimestamp?: unknown;
    }[];
    tags?: Record<string, string> | undefined;
    homepage?: string | undefined;
    changelogUrl?: string | undefined;
    sourceUrl?: string | undefined;
    sourceDirectory?: string | undefined;
}>;
