"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlainFetcher = void 0;
const fs_1 = require("../../../../util/fs");
const regex_1 = require("../../../../util/regex");
function convertLinesToVersions(content) {
    const lines = content.split(regex_1.newlineRegex).map((line) => line.trim());
    const versions = lines.map((value) => {
        return { version: value };
    });
    return {
        releases: versions,
    };
}
class PlainFetcher {
    async fetch(http, registryURL) {
        const response = await http.getPlain(registryURL);
        return convertLinesToVersions(response.body);
    }
    async readFile(registryURL) {
        const fileContent = await (0, fs_1.readLocalFile)(registryURL, 'utf8');
        return fileContent ? convertLinesToVersions(fileContent) : null;
    }
}
exports.PlainFetcher = PlainFetcher;
//# sourceMappingURL=plain.js.map