"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HtmlFetcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const fs_1 = require("../../../../util/fs");
const html_1 = require("../../../../util/html");
function extractLinks(content) {
    const body = (0, html_1.parse)(content);
    // node-html-parser doesn't parse anything inside <pre>
    // but, for example, nginx wraps directory listings in <pre>
    const pres = body
        .getElementsByTagName('pre')
        .map((pre) => (0, html_1.parse)(pre.textContent));
    const links = [body, ...pres].flatMap((e) => e.getElementsByTagName('a'));
    const hrefs = links
        .map((node) => node.getAttribute('href'))
        .filter(is_1.default.truthy);
    const releases = hrefs.map((href) => {
        return {
            version: href,
        };
    });
    return { releases };
}
class HtmlFetcher {
    async fetch(http, registryURL) {
        const response = await http.getText(registryURL, {
            headers: {
                Accept: 'text/html',
            },
        });
        return extractLinks(response.body);
    }
    async readFile(registryURL) {
        const fileContent = await (0, fs_1.readLocalFile)(registryURL, 'utf8');
        return fileContent ? extractLinks(fileContent) : null;
    }
}
exports.HtmlFetcher = HtmlFetcher;
//# sourceMappingURL=html.js.map