"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReleaseTimestampSchema = void 0;
const zod_1 = require("zod");
const timestamp_1 = require("../../../util/timestamp");
exports.ReleaseTimestampSchema = zod_1.z
    .object({
    version: zod_1.z.object({
        created_at: timestamp_1.MaybeTimestamp,
    }),
})
    .transform(({ version: { created_at } }) => created_at)
    .nullable()
    .catch(null);
//# sourceMappingURL=schema.js.map