"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaCpanApiFileSearchResponse = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const timestamp_1 = require("../../../util/timestamp");
/**
 * https://fastapi.metacpan.org/v1/file/_mapping
 */
const MetaCpanApiFileSchema = zod_1.z
    .object({
    module: (0, schema_utils_1.LooseArray)(zod_1.z.object({
        name: zod_1.z.string(),
        version: zod_1.z.string(),
    })),
    distribution: zod_1.z.string(),
    date: timestamp_1.MaybeTimestamp,
    deprecated: zod_1.z.boolean(),
    maturity: zod_1.z.string(),
    status: zod_1.z.union([
        zod_1.z.literal('backpan'),
        zod_1.z.literal('cpan'),
        zod_1.z.literal('latest'),
    ]),
})
    .transform(({ module, distribution, date, deprecated, maturity, status, }) => {
    return {
        version: module[0].version,
        distribution,
        isDeprecated: deprecated,
        isStable: maturity === 'released',
        releaseTimestamp: date,
        isLatest: status === 'latest',
    };
})
    .catch(undefined);
/**
 * https://github.com/metacpan/metacpan-api/blob/master/docs/API-docs.md#available-fields
 */
exports.MetaCpanApiFileSearchResponse = zod_1.z
    .object({
    hits: zod_1.z.object({
        hits: (0, schema_utils_1.LooseArray)(zod_1.z.object({
            _source: MetaCpanApiFileSchema,
        })),
    }),
})
    .transform((data) => {
    // Extract all hits and filter out ones where _source transformed to undefined
    return data.hits.hits
        .map((hit) => hit._source)
        .filter((source) => source !== undefined);
});
//# sourceMappingURL=schema.js.map