import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class CpanDatasource extends Datasource {
    static readonly id = "cpan";
    constructor();
    readonly customRegistrySupport = false;
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "perl";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `date` field in the results.";
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
