import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class CondaDatasource extends Datasource {
    static readonly id = "conda";
    constructor();
    readonly customRegistrySupport = true;
    readonly registryStrategy = "hunt";
    readonly defaultRegistryUrls: string[];
    readonly caching = true;
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined from the `dev_url` field in the results.";
    getReleases({ registryUrl, packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
