"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConanProperties = exports.ConanLatestRevision = exports.ConanRevisionJSON = exports.ConanJSON = exports.ConanCenterReleases = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const common_1 = require("./common");
exports.ConanCenterReleases = zod_1.z
    .object({
    versions: zod_1.z.record(zod_1.z.string(), zod_1.z.unknown()),
})
    .transform(({ versions }) => ({
    releases: Object.keys(versions).map((version) => ({ version })),
}))
    .nullable()
    .catch(null);
exports.ConanJSON = zod_1.z
    .object({
    results: zod_1.z
        .string()
        .array()
        .transform((array) => array.map((val) => val.match(common_1.conanDatasourceRegex)?.groups))
        .pipe((0, schema_utils_1.LooseArray)(zod_1.z.object({
        name: zod_1.z.string(),
        version: zod_1.z.string(),
        userChannel: zod_1.z.string(),
    }))),
})
    .transform(({ results }) => results)
    .nullable()
    .catch(null);
exports.ConanRevisionJSON = zod_1.z.object({
    revision: zod_1.z.string(),
    time: zod_1.z.string(),
});
exports.ConanLatestRevision = zod_1.z
    .object({ revisions: zod_1.z.unknown().array() })
    .transform(({ revisions }) => revisions[0])
    .pipe(exports.ConanRevisionJSON)
    .transform(({ revision }) => revision)
    .nullable()
    .catch(null);
exports.ConanProperties = zod_1.z
    .object({
    properties: zod_1.z.object({
        'conan.package.url': zod_1.z.union([
            zod_1.z.string().transform((url) => [url]),
            zod_1.z.string().array(),
        ]),
    }),
})
    .transform(({ properties }) => {
    const sourceUrl = properties['conan.package.url'][0];
    return { sourceUrl };
});
//# sourceMappingURL=schema.js.map