import { z } from 'zod';
import type { ReleaseResult } from '../types';
export declare const ConanCenterReleases: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodObject<{
    versions: z.ZodRecord<z.ZodString, z.ZodUnknown>;
}, "strip", z.ZodTypeAny, {
    versions: Record<string, unknown>;
}, {
    versions: Record<string, unknown>;
}>, ReleaseResult, {
    versions: Record<string, unknown>;
}>>>;
export declare const ConanJSON: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodObject<{
    results: z.ZodPipeline<z.ZodEffects<z.ZodArray<z.ZodString, "many">, ({
        [key: string]: string;
    } | undefined)[], string[]>, z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        name: string;
        version: string;
        userChannel: string;
    }[], any[]>>;
}, "strip", z.ZodTypeAny, {
    results: {
        name: string;
        version: string;
        userChannel: string;
    }[];
}, {
    results: string[];
}>, {
    name: string;
    version: string;
    userChannel: string;
}[], {
    results: string[];
}>>>;
export declare const ConanRevisionJSON: z.ZodObject<{
    revision: z.ZodString;
    time: z.ZodString;
}, "strip", z.ZodTypeAny, {
    time: string;
    revision: string;
}, {
    time: string;
    revision: string;
}>;
export declare const ConanLatestRevision: z.ZodCatch<z.ZodNullable<z.ZodEffects<z.ZodPipeline<z.ZodEffects<z.ZodObject<{
    revisions: z.ZodArray<z.ZodUnknown, "many">;
}, "strip", z.ZodTypeAny, {
    revisions: unknown[];
}, {
    revisions: unknown[];
}>, unknown, {
    revisions: unknown[];
}>, z.ZodObject<{
    revision: z.ZodString;
    time: z.ZodString;
}, "strip", z.ZodTypeAny, {
    time: string;
    revision: string;
}, {
    time: string;
    revision: string;
}>>, string, {
    revisions: unknown[];
}>>>;
export declare const ConanProperties: z.ZodEffects<z.ZodObject<{
    properties: z.ZodObject<{
        'conan.package.url': z.ZodUnion<[z.ZodEffects<z.ZodString, string[], string>, z.ZodArray<z.ZodString, "many">]>;
    }, "strip", z.ZodTypeAny, {
        'conan.package.url': string[];
    }, {
        'conan.package.url': string | string[];
    }>;
}, "strip", z.ZodTypeAny, {
    properties: {
        'conan.package.url': string[];
    };
}, {
    properties: {
        'conan.package.url': string | string[];
    };
}>, {
    sourceUrl: string;
}, {
    properties: {
        'conan.package.url': string | string[];
    };
}>;
