"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.conanDatasourceRegex = exports.datasource = exports.defaultRegistryUrl = void 0;
exports.getConanPackage = getConanPackage;
const regex_1 = require("../../../util/regex");
exports.defaultRegistryUrl = 'https://center2.conan.io/';
exports.datasource = 'conan';
exports.conanDatasourceRegex = (0, regex_1.regEx)(/^(?<name>[a-zA-Z\-_0-9]+)\/(?<version>[^@/\n]+)(?<userChannel>@\S+\/\S+)$/im);
function getConanPackage(packageName) {
    const conanName = packageName.split('/')[0];
    const userAndChannel = packageName.split('@')[1];
    return { conanName, userAndChannel };
}
//# sourceMappingURL=common.js.map