import { z } from 'zod';
import type { Release } from '../types';
export declare const Homepage: z.ZodCatch<z.ZodOptional<z.ZodString>>;
export declare const Repository: z.ZodCatch<z.ZodOptional<z.ZodEffects<z.ZodObject<{
    type: z.ZodLiteral<"git">;
    url: z.ZodString;
}, "strip", z.ZodTypeAny, {
    type: "git";
    url: string;
}, {
    type: "git";
    url: string;
}>, string, {
    type: "git";
    url: string;
}>>>;
export declare const Versions: z.ZodArray<z.ZodEffects<z.ZodString, Release, string>, "many">;
export declare const Sri: z.ZodRecord<z.ZodString, z.ZodString>;
export declare const CdnjsAPIVersionResponseSchema: z.ZodObject<{
    homepage: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    repository: z.ZodCatch<z.ZodOptional<z.ZodEffects<z.ZodObject<{
        type: z.ZodLiteral<"git">;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        type: "git";
        url: string;
    }, {
        type: "git";
        url: string;
    }>, string, {
        type: "git";
        url: string;
    }>>>;
    versions: z.ZodArray<z.ZodEffects<z.ZodString, Release, string>, "many">;
}, "strip", z.ZodTypeAny, {
    versions: Release[];
    homepage?: string | undefined;
    repository?: string | undefined;
}, {
    versions: string[];
    homepage?: unknown;
    repository?: unknown;
}>;
export declare const CdnjsAPISriResponseSchema: z.ZodObject<{
    sri: z.ZodRecord<z.ZodString, z.ZodString>;
}, "strip", z.ZodTypeAny, {
    sri: Record<string, string>;
}, {
    sri: Record<string, string>;
}>;
