import type { HttpError } from '../../../util/http';
import { Datasource } from '../datasource';
import type { DigestConfig, GetReleasesConfig, ReleaseResult } from '../types';
export declare class CdnjsDatasource extends Datasource {
    static readonly id = "cdnjs";
    constructor();
    readonly customRegistrySupport = false;
    readonly defaultRegistryUrls: string[];
    readonly sourceUrlSupport = "package";
    readonly sourceUrlNote = "The source URL is determined from the `repository` field in the results.";
    getReleases(config: GetReleasesConfig): Promise<ReleaseResult | null>;
    getDigest(config: DigestConfig, newValue: string): Promise<string | null>;
    handleHttpErrors(err: HttpError): void;
}
