import { z } from 'zod';
export declare const BazelModuleMetadata: z.ZodObject<{
    homepage: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    versions: z.ZodArray<z.ZodString, "many">;
    yanked_versions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    versions: string[];
    homepage?: string | null | undefined;
    yanked_versions?: Record<string, string> | undefined;
}, {
    versions: string[];
    homepage?: string | null | undefined;
    yanked_versions?: Record<string, string> | undefined;
}>;
export type BazelModuleMetadata = z.infer<typeof BazelModuleMetadata>;
