"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzurePipelinesFallbackTasks = exports.AzurePipelinesJSON = exports.AzurePipelinesTask = exports.AzurePipelinesTaskVersion = void 0;
const zod_1 = require("zod");
exports.AzurePipelinesTaskVersion = zod_1.z.object({
    major: zod_1.z.number(),
    minor: zod_1.z.number(),
    patch: zod_1.z.number(),
});
exports.AzurePipelinesTask = zod_1.z.object({
    id: zod_1.z.string(),
    name: zod_1.z.string(),
    deprecated: zod_1.z.boolean().optional(),
    releaseNotes: zod_1.z.string().optional(),
    serverOwned: zod_1.z.boolean().optional(),
    version: exports.AzurePipelinesTaskVersion.nullable(),
    contributionIdentifier: zod_1.z.string().optional(),
});
exports.AzurePipelinesJSON = zod_1.z.object({
    value: exports.AzurePipelinesTask.array(),
});
exports.AzurePipelinesFallbackTasks = zod_1.z.record(zod_1.z.string().array());
//# sourceMappingURL=schema.js.map