import { z } from 'zod';
export declare const AzurePipelinesTaskVersion: z.ZodObject<{
    major: z.ZodNumber;
    minor: z.ZodNumber;
    patch: z.ZodNumber;
}, "strip", z.ZodTypeAny, {
    major: number;
    minor: number;
    patch: number;
}, {
    major: number;
    minor: number;
    patch: number;
}>;
export declare const AzurePipelinesTask: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    deprecated: z.ZodOptional<z.ZodBoolean>;
    releaseNotes: z.ZodOptional<z.ZodString>;
    serverOwned: z.ZodOptional<z.ZodBoolean>;
    version: z.ZodNullable<z.ZodObject<{
        major: z.ZodNumber;
        minor: z.ZodNumber;
        patch: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        major: number;
        minor: number;
        patch: number;
    }, {
        major: number;
        minor: number;
        patch: number;
    }>>;
    contributionIdentifier: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    id: string;
    name: string;
    version: {
        major: number;
        minor: number;
        patch: number;
    } | null;
    deprecated?: boolean | undefined;
    releaseNotes?: string | undefined;
    serverOwned?: boolean | undefined;
    contributionIdentifier?: string | undefined;
}, {
    id: string;
    name: string;
    version: {
        major: number;
        minor: number;
        patch: number;
    } | null;
    deprecated?: boolean | undefined;
    releaseNotes?: string | undefined;
    serverOwned?: boolean | undefined;
    contributionIdentifier?: string | undefined;
}>;
export declare const AzurePipelinesJSON: z.ZodObject<{
    value: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        deprecated: z.ZodOptional<z.ZodBoolean>;
        releaseNotes: z.ZodOptional<z.ZodString>;
        serverOwned: z.ZodOptional<z.ZodBoolean>;
        version: z.ZodNullable<z.ZodObject<{
            major: z.ZodNumber;
            minor: z.ZodNumber;
            patch: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            major: number;
            minor: number;
            patch: number;
        }, {
            major: number;
            minor: number;
            patch: number;
        }>>;
        contributionIdentifier: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        id: string;
        name: string;
        version: {
            major: number;
            minor: number;
            patch: number;
        } | null;
        deprecated?: boolean | undefined;
        releaseNotes?: string | undefined;
        serverOwned?: boolean | undefined;
        contributionIdentifier?: string | undefined;
    }, {
        id: string;
        name: string;
        version: {
            major: number;
            minor: number;
            patch: number;
        } | null;
        deprecated?: boolean | undefined;
        releaseNotes?: string | undefined;
        serverOwned?: boolean | undefined;
        contributionIdentifier?: string | undefined;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    value: {
        id: string;
        name: string;
        version: {
            major: number;
            minor: number;
            patch: number;
        } | null;
        deprecated?: boolean | undefined;
        releaseNotes?: string | undefined;
        serverOwned?: boolean | undefined;
        contributionIdentifier?: string | undefined;
    }[];
}, {
    value: {
        id: string;
        name: string;
        version: {
            major: number;
            minor: number;
            patch: number;
        } | null;
        deprecated?: boolean | undefined;
        releaseNotes?: string | undefined;
        serverOwned?: boolean | undefined;
        contributionIdentifier?: string | undefined;
    }[];
}>;
export declare const AzurePipelinesFallbackTasks: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodString, "many">>;
