import type { TypeOf, ZodType } from 'zod';
import type { HttpOptions } from '../../../util/http/types';
import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class AzurePipelinesTasksDatasource extends Datasource {
    static readonly id = "azure-pipelines-tasks";
    constructor();
    readonly customRegistrySupport = false;
    readonly defaultVersioning = "loose";
    getReleases({ packageName, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    getTasks<Schema extends ZodType>(url: string, opts: HttpOptions, schema: Schema): Promise<TypeOf<Schema>>;
    static compareSemanticVersions: (key: string) => (a: any, b: any) => number;
}
