"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzureBicepResourceDatasource = void 0;
const tslib_1 = require("tslib");
const decorator_1 = require("../../../util/cache/package/decorator");
const azureRestApiVersioningApi = tslib_1.__importStar(require("../../versioning/azure-rest-api"));
const datasource_1 = require("../datasource");
const schema_1 = require("./schema");
const BICEP_TYPES_INDEX_URL = 'https://raw.githubusercontent.com/Azure/bicep-types-az/main/generated/index.json';
class AzureBicepResourceDatasource extends datasource_1.Datasource {
    static id = 'azure-bicep-resource';
    defaultConfig = {
        commitMessageTopic: 'resource {{depName}}',
        commitMessageExtra: 'to {{{newVersion}}}',
        prBodyColumns: ['Resource', 'Change'],
        prBodyDefinitions: {
            Resource: '{{{depNameLinked}}}',
        },
    };
    defaultVersioning = azureRestApiVersioningApi.id;
    constructor() {
        super(AzureBicepResourceDatasource.id);
    }
    getChangelogUrl(packageName) {
        const firstSlashIndex = packageName.indexOf('/');
        const namespaceProvider = packageName.slice(0, firstSlashIndex);
        const type = packageName.slice(firstSlashIndex + 1);
        return `https://learn.microsoft.com/en-us/azure/templates/${namespaceProvider}/change-log/${type}`;
    }
    async getReleases(getReleasesConfig) {
        const resourceVersionIndex = await this.getResourceVersionIndex();
        const packageName = getReleasesConfig.packageName.toLowerCase();
        const versions = resourceVersionIndex[packageName];
        if (!versions?.length) {
            return null;
        }
        const changelogUrl = this.getChangelogUrl(packageName);
        const releases = versions.map((version) => ({
            version,
            changelogUrl: `${changelogUrl}#${version}`,
        }));
        return { releases };
    }
    async getResourceVersionIndex() {
        const { body } = await this.http.getJson(BICEP_TYPES_INDEX_URL, schema_1.BicepResourceVersionIndex);
        return body;
    }
}
exports.AzureBicepResourceDatasource = AzureBicepResourceDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${AzureBicepResourceDatasource.id}`,
        key: ({ packageName }) => `getReleases-${packageName}`,
    })
], AzureBicepResourceDatasource.prototype, "getReleases", null);
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${AzureBicepResourceDatasource.id}`,
        key: 'getResourceVersionIndex',
        ttlMinutes: 24 * 60,
    })
], AzureBicepResourceDatasource.prototype, "getResourceVersionIndex", null);
//# sourceMappingURL=index.js.map