"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsRdsDatasource = void 0;
const tslib_1 = require("tslib");
const client_rds_1 = require("@aws-sdk/client-rds");
const decorator_1 = require("../../../util/cache/package/decorator");
const lazy_1 = require("../../../util/lazy");
const datasource_1 = require("../datasource");
class AwsRdsDatasource extends datasource_1.Datasource {
    static id = 'aws-rds';
    caching = true;
    rds;
    constructor() {
        super(AwsRdsDatasource.id);
        this.rds = new lazy_1.Lazy(() => new client_rds_1.RDSClient({}));
    }
    async getReleases({ packageName: serializedFilter, }) {
        const cmd = new client_rds_1.DescribeDBEngineVersionsCommand({
            Filters: JSON.parse(serializedFilter),
        });
        const response = await this.rds.getValue().send(cmd);
        const versions = response.DBEngineVersions ?? [];
        return {
            releases: versions
                .filter((version) => version.EngineVersion)
                .map((version) => ({
                version: version.EngineVersion,
                isDeprecated: version.Status === 'deprecated',
            })),
        };
    }
}
exports.AwsRdsDatasource = AwsRdsDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${AwsRdsDatasource.id}`,
        key: ({ packageName }) => `getReleases:${packageName}`,
    })
], AwsRdsDatasource.prototype, "getReleases", null);
//# sourceMappingURL=index.js.map