import type { Filter, Image } from '@aws-sdk/client-ec2';
import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
import type { AwsClientConfig } from './types';
export declare class AwsMachineImageDatasource extends Datasource {
    static readonly id = "aws-machine-image";
    readonly defaultVersioning = "aws-machine-image";
    readonly caching = true;
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `CreationDate` field in the results.";
    readonly defaultConfig: {
        commitMessageExtra: string;
        prBodyColumns: string[];
        prBodyDefinitions: {
            Image: string;
        };
        digest: {
            commitMessageExtra: string;
            prBodyColumns: string[];
            prBodyDefinitions: {
                Image: string;
            };
        };
    };
    private readonly now;
    constructor();
    private isAmiFilter;
    private getEC2Client;
    private getAmiFilterCommand;
    loadConfig(serializedAmiFilter: string): [Filter[], AwsClientConfig];
    getSortedAwsMachineImages(serializedAmiFilter: string): Promise<Image[]>;
    getDigest({ packageName: serializedAmiFilter }: GetReleasesConfig, newValue?: string): Promise<string | null>;
    getReleases({ packageName: serializedAmiFilter, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
