import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class ArtifactoryDatasource extends Datasource {
    static readonly id = "artifactory";
    constructor();
    readonly customRegistrySupport = true;
    readonly caching = true;
    readonly registryStrategy = "merge";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the date-like text, next to the version hyperlink tag in the results.";
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
