"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const artifactory_1 = require("./artifactory");
const aws_eks_addon_1 = require("./aws-eks-addon");
const aws_machine_image_1 = require("./aws-machine-image");
const aws_rds_1 = require("./aws-rds");
const azure_bicep_resource_1 = require("./azure-bicep-resource");
const azure_pipelines_tasks_1 = require("./azure-pipelines-tasks");
const bazel_1 = require("./bazel");
const bitbucket_server_tags_1 = require("./bitbucket-server-tags");
const bitbucket_tags_1 = require("./bitbucket-tags");
const bitrise_1 = require("./bitrise");
const buildpacks_registry_1 = require("./buildpacks-registry");
const cdnjs_1 = require("./cdnjs");
const clojure_1 = require("./clojure");
const conan_1 = require("./conan");
const conda_1 = require("./conda");
const cpan_1 = require("./cpan");
const crate_1 = require("./crate");
const custom_1 = require("./custom");
const dart_1 = require("./dart");
const dart_version_1 = require("./dart-version");
const deb_1 = require("./deb");
const deno_1 = require("./deno");
const devbox_1 = require("./devbox");
const docker_1 = require("./docker");
const dotnet_version_1 = require("./dotnet-version");
const endoflife_date_1 = require("./endoflife-date");
const flutter_version_1 = require("./flutter-version");
const galaxy_1 = require("./galaxy");
const galaxy_collection_1 = require("./galaxy-collection");
const git_refs_1 = require("./git-refs");
const git_tags_1 = require("./git-tags");
const gitea_releases_1 = require("./gitea-releases");
const gitea_tags_1 = require("./gitea-tags");
const github_release_attachments_1 = require("./github-release-attachments");
const github_releases_1 = require("./github-releases");
const github_runners_1 = require("./github-runners");
const github_tags_1 = require("./github-tags");
const gitlab_packages_1 = require("./gitlab-packages");
const gitlab_releases_1 = require("./gitlab-releases");
const gitlab_tags_1 = require("./gitlab-tags");
const glasskube_packages_1 = require("./glasskube-packages");
const go_1 = require("./go");
const golang_version_1 = require("./golang-version");
const gradle_version_1 = require("./gradle-version");
const hackage_1 = require("./hackage");
const helm_1 = require("./helm");
const hermit_1 = require("./hermit");
const hex_1 = require("./hex");
const hexpm_bob_1 = require("./hexpm-bob");
const java_version_1 = require("./java-version");
const jenkins_plugins_1 = require("./jenkins-plugins");
const kubernetes_api_1 = require("./kubernetes-api");
const maven_1 = require("./maven");
const node_version_1 = require("./node-version");
const npm_1 = require("./npm");
const nuget_1 = require("./nuget");
const orb_1 = require("./orb");
const packagist_1 = require("./packagist");
const pod_1 = require("./pod");
const puppet_forge_1 = require("./puppet-forge");
const pypi_1 = require("./pypi");
const python_version_1 = require("./python-version");
const repology_1 = require("./repology");
const rpm_1 = require("./rpm");
const ruby_version_1 = require("./ruby-version");
const rubygems_1 = require("./rubygems");
const sbt_package_1 = require("./sbt-package");
const sbt_plugin_1 = require("./sbt-plugin");
const terraform_module_1 = require("./terraform-module");
const terraform_provider_1 = require("./terraform-provider");
const unity3d_1 = require("./unity3d");
const unity3d_packages_1 = require("./unity3d-packages");
const api = new Map();
exports.default = api;
api.set(artifactory_1.ArtifactoryDatasource.id, new artifactory_1.ArtifactoryDatasource());
api.set(aws_eks_addon_1.AwsEKSAddonDataSource.id, new aws_eks_addon_1.AwsEKSAddonDataSource());
api.set(aws_machine_image_1.AwsMachineImageDatasource.id, new aws_machine_image_1.AwsMachineImageDatasource());
api.set(aws_rds_1.AwsRdsDatasource.id, new aws_rds_1.AwsRdsDatasource());
api.set(azure_bicep_resource_1.AzureBicepResourceDatasource.id, new azure_bicep_resource_1.AzureBicepResourceDatasource());
api.set(azure_pipelines_tasks_1.AzurePipelinesTasksDatasource.id, new azure_pipelines_tasks_1.AzurePipelinesTasksDatasource());
api.set(bazel_1.BazelDatasource.id, new bazel_1.BazelDatasource());
api.set(bitbucket_server_tags_1.BitbucketServerTagsDatasource.id, new bitbucket_server_tags_1.BitbucketServerTagsDatasource());
api.set(bitbucket_tags_1.BitbucketTagsDatasource.id, new bitbucket_tags_1.BitbucketTagsDatasource());
api.set(bitrise_1.BitriseDatasource.id, new bitrise_1.BitriseDatasource());
api.set(buildpacks_registry_1.BuildpacksRegistryDatasource.id, new buildpacks_registry_1.BuildpacksRegistryDatasource());
api.set(cdnjs_1.CdnjsDatasource.id, new cdnjs_1.CdnjsDatasource());
api.set(clojure_1.ClojureDatasource.id, new clojure_1.ClojureDatasource());
api.set(conan_1.ConanDatasource.id, new conan_1.ConanDatasource());
api.set(conda_1.CondaDatasource.id, new conda_1.CondaDatasource());
api.set(cpan_1.CpanDatasource.id, new cpan_1.CpanDatasource());
api.set(crate_1.CrateDatasource.id, new crate_1.CrateDatasource());
api.set(custom_1.CustomDatasource.id, new custom_1.CustomDatasource());
api.set(dart_1.DartDatasource.id, new dart_1.DartDatasource());
api.set(dart_version_1.DartVersionDatasource.id, new dart_version_1.DartVersionDatasource());
api.set(deb_1.DebDatasource.id, new deb_1.DebDatasource());
api.set(deno_1.DenoDatasource.id, new deno_1.DenoDatasource());
api.set(devbox_1.DevboxDatasource.id, new devbox_1.DevboxDatasource());
api.set(docker_1.DockerDatasource.id, new docker_1.DockerDatasource());
api.set(dotnet_version_1.DotnetVersionDatasource.id, new dotnet_version_1.DotnetVersionDatasource());
api.set(endoflife_date_1.EndoflifeDateDatasource.id, new endoflife_date_1.EndoflifeDateDatasource());
api.set(flutter_version_1.FlutterVersionDatasource.id, new flutter_version_1.FlutterVersionDatasource());
api.set(galaxy_1.GalaxyDatasource.id, new galaxy_1.GalaxyDatasource());
api.set(galaxy_collection_1.GalaxyCollectionDatasource.id, new galaxy_collection_1.GalaxyCollectionDatasource());
api.set(git_refs_1.GitRefsDatasource.id, new git_refs_1.GitRefsDatasource());
api.set(git_tags_1.GitTagsDatasource.id, new git_tags_1.GitTagsDatasource());
api.set(gitea_releases_1.GiteaReleasesDatasource.id, new gitea_releases_1.GiteaReleasesDatasource());
api.set(gitea_tags_1.GiteaTagsDatasource.id, new gitea_tags_1.GiteaTagsDatasource());
api.set(github_release_attachments_1.GithubReleaseAttachmentsDatasource.id, new github_release_attachments_1.GithubReleaseAttachmentsDatasource());
api.set(github_releases_1.GithubReleasesDatasource.id, new github_releases_1.GithubReleasesDatasource());
api.set(github_runners_1.GithubRunnersDatasource.id, new github_runners_1.GithubRunnersDatasource());
api.set(github_tags_1.GithubTagsDatasource.id, new github_tags_1.GithubTagsDatasource());
api.set(gitlab_packages_1.GitlabPackagesDatasource.id, new gitlab_packages_1.GitlabPackagesDatasource());
api.set(gitlab_releases_1.GitlabReleasesDatasource.id, new gitlab_releases_1.GitlabReleasesDatasource());
api.set(gitlab_tags_1.GitlabTagsDatasource.id, new gitlab_tags_1.GitlabTagsDatasource());
api.set(glasskube_packages_1.GlasskubePackagesDatasource.id, new glasskube_packages_1.GlasskubePackagesDatasource());
api.set(go_1.GoDatasource.id, new go_1.GoDatasource());
api.set(golang_version_1.GolangVersionDatasource.id, new golang_version_1.GolangVersionDatasource());
api.set(gradle_version_1.GradleVersionDatasource.id, new gradle_version_1.GradleVersionDatasource());
api.set(hackage_1.HackageDatasource.id, new hackage_1.HackageDatasource());
api.set(helm_1.HelmDatasource.id, new helm_1.HelmDatasource());
api.set(hermit_1.HermitDatasource.id, new hermit_1.HermitDatasource());
api.set(hex_1.HexDatasource.id, new hex_1.HexDatasource());
api.set(hexpm_bob_1.HexpmBobDatasource.id, new hexpm_bob_1.HexpmBobDatasource());
api.set(java_version_1.JavaVersionDatasource.id, new java_version_1.JavaVersionDatasource());
api.set(jenkins_plugins_1.JenkinsPluginsDatasource.id, new jenkins_plugins_1.JenkinsPluginsDatasource());
api.set(kubernetes_api_1.KubernetesApiDatasource.id, new kubernetes_api_1.KubernetesApiDatasource());
api.set(maven_1.MavenDatasource.id, new maven_1.MavenDatasource());
api.set(node_version_1.NodeVersionDatasource.id, new node_version_1.NodeVersionDatasource());
api.set(npm_1.NpmDatasource.id, new npm_1.NpmDatasource());
api.set(nuget_1.NugetDatasource.id, new nuget_1.NugetDatasource());
api.set(orb_1.OrbDatasource.id, new orb_1.OrbDatasource());
api.set(packagist_1.PackagistDatasource.id, new packagist_1.PackagistDatasource());
api.set(pod_1.PodDatasource.id, new pod_1.PodDatasource());
api.set(puppet_forge_1.PuppetForgeDatasource.id, new puppet_forge_1.PuppetForgeDatasource());
api.set(pypi_1.PypiDatasource.id, new pypi_1.PypiDatasource());
api.set(python_version_1.PythonVersionDatasource.id, new python_version_1.PythonVersionDatasource());
api.set(repology_1.RepologyDatasource.id, new repology_1.RepologyDatasource());
api.set(rpm_1.RpmDatasource.id, new rpm_1.RpmDatasource());
api.set(ruby_version_1.RubyVersionDatasource.id, new ruby_version_1.RubyVersionDatasource());
api.set(rubygems_1.RubygemsDatasource.id, new rubygems_1.RubygemsDatasource());
api.set(sbt_package_1.SbtPackageDatasource.id, new sbt_package_1.SbtPackageDatasource());
api.set(sbt_plugin_1.SbtPluginDatasource.id, new sbt_plugin_1.SbtPluginDatasource());
api.set(terraform_module_1.TerraformModuleDatasource.id, new terraform_module_1.TerraformModuleDatasource());
api.set(terraform_provider_1.TerraformProviderDatasource.id, new terraform_provider_1.TerraformProviderDatasource());
api.set(unity3d_1.Unity3dDatasource.id, new unity3d_1.Unity3dDatasource());
api.set(unity3d_packages_1.Unity3dPackagesDatasource.id, new unity3d_packages_1.Unity3dPackagesDatasource());
//# sourceMappingURL=api.js.map