import { Stream } from 'node:stream';
import bunyan from 'bunyan';
import { ZodError } from 'zod';
import type { BunyanRecord } from './types';
export declare class ProblemStream extends Stream {
    private _problems;
    readable: boolean;
    writable: boolean;
    constructor();
    write(data: BunyanRecord): boolean;
    getProblems(): BunyanRecord[];
    clearProblems(): void;
}
type ZodShortenedIssue = null | string | string[] | {
    [key: string]: ZodShortenedIssue;
};
export declare function prepareZodIssues(input: unknown): ZodShortenedIssue;
export declare function prepareZodError(err: ZodError): Record<string, unknown>;
export default function prepareError(err: Error): Record<string, unknown>;
type NestedValue = unknown[] | object;
export declare function sanitizeValue(value: unknown, seen?: WeakMap<NestedValue, unknown>): any;
export declare function withSanitizer(streamConfig: bunyan.Stream): bunyan.Stream;
/**
 * A function that terminates execution if the log level that was entered is
 *  not a valid value for the Bunyan logger.
 * @param logLevelToCheck
 * @returns returns the logLevel when the logLevelToCheck is valid or the defaultLevel passed as argument when it is undefined. Else it stops execution.
 */
export declare function validateLogLevel(logLevelToCheck: string | undefined, defaultLevel: bunyan.LogLevelString): bunyan.LogLevelString;
export declare function sanitizeUrls(text: string): string;
export declare function getEnv(key: string): string | undefined;
export declare function getMessage(p1: string | Record<string, any>, p2?: string): string | undefined;
export declare function toMeta(p1: string | Record<string, any>): Record<string, unknown>;
export {};
