"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRemappedLevel = getRemappedLevel;
exports.setGlobalLogLevelRemaps = setGlobalLogLevelRemaps;
exports.resetGlobalLogLevelRemaps = resetGlobalLogLevelRemaps;
exports.setRepositoryLogLevelRemaps = setRepositoryLogLevelRemaps;
exports.resetRepositoryLogLevelRemaps = resetRepositoryLogLevelRemaps;
const string_match_1 = require("../util/string-match");
let globalRemaps;
let repositoryRemaps;
let matcherCache = new WeakMap();
function match(remap, input) {
    const { matchMessage: pattern } = remap;
    let matchFn = matcherCache.get(remap);
    if (!matchFn) {
        matchFn = (0, string_match_1.getRegexOrGlobPredicate)(pattern);
        matcherCache.set(remap, matchFn);
    }
    return matchFn(input);
}
function getRemappedLevel(msg) {
    if (repositoryRemaps) {
        for (const remap of repositoryRemaps) {
            if (match(remap, msg)) {
                return remap.newLogLevel;
            }
        }
    }
    if (globalRemaps) {
        for (const remap of globalRemaps) {
            if (match(remap, msg)) {
                return remap.newLogLevel;
            }
        }
    }
    return null;
}
function resetMatcherCache() {
    matcherCache = new WeakMap();
}
function setGlobalLogLevelRemaps(remaps) {
    globalRemaps = remaps;
}
function resetGlobalLogLevelRemaps() {
    globalRemaps = undefined;
    resetMatcherCache();
}
function setRepositoryLogLevelRemaps(remaps) {
    repositoryRemaps = remaps;
}
function resetRepositoryLogLevelRemaps() {
    repositoryRemaps = undefined;
    resetMatcherCache();
}
//# sourceMappingURL=remap.js.map