"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = configSerializer;
const tslib_1 = require("tslib");
const legacy_1 = tslib_1.__importDefault(require("neotraverse/legacy"));
function configSerializer(config) {
    const templateFields = ['prBody'];
    const contentFields = [
        'content',
        'contents',
        'packageLockParsed',
        'yarnLockParsed',
    ];
    const arrayFields = ['packageFiles', 'upgrades'];
    return (0, legacy_1.default)(config).map(function scrub(val) {
        if (this.key && val) {
            const key = this.key.toString();
            if (templateFields.includes(key)) {
                this.update('[Template]');
            }
            if (contentFields.includes(key)) {
                this.update('[content]');
            }
            if (arrayFields.includes(key)) {
                this.update('[Array]');
            }
        }
    });
}
//# sourceMappingURL=config-serializer.js.map