"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const data = new Map();
data.set('data/debian-distro-info.json', "{\n  \"v1.1\": {\n    \"codename\": \"Buzz\",\n    \"series\": \"buzz\",\n    \"created\": \"1993-08-16\",\n    \"release\": \"1996-06-17\",\n    \"eol\": \"1997-06-05\"\n  },\n  \"v1.2\": {\n    \"codename\": \"Rex\",\n    \"series\": \"rex\",\n    \"created\": \"1996-06-17\",\n    \"release\": \"1996-12-12\",\n    \"eol\": \"1998-06-05\"\n  },\n  \"v1.3\": {\n    \"codename\": \"Bo\",\n    \"series\": \"bo\",\n    \"created\": \"1996-12-12\",\n    \"release\": \"1997-06-05\",\n    \"eol\": \"1999-03-09\"\n  },\n  \"v2\": {\n    \"codename\": \"Hamm\",\n    \"series\": \"hamm\",\n    \"created\": \"1997-06-05\",\n    \"release\": \"1998-07-24\",\n    \"eol\": \"2000-03-09\"\n  },\n  \"v2.1\": {\n    \"codename\": \"Slink\",\n    \"series\": \"slink\",\n    \"created\": \"1998-07-24\",\n    \"release\": \"1999-03-09\",\n    \"eol\": \"2000-10-30\"\n  },\n  \"v2.2\": {\n    \"codename\": \"Potato\",\n    \"series\": \"potato\",\n    \"created\": \"1999-03-09\",\n    \"release\": \"2000-08-15\",\n    \"eol\": \"2003-06-30\"\n  },\n  \"v3\": {\n    \"codename\": \"Woody\",\n    \"series\": \"woody\",\n    \"created\": \"2000-08-15\",\n    \"release\": \"2002-07-19\",\n    \"eol\": \"2006-06-30\"\n  },\n  \"v3.1\": {\n    \"codename\": \"Sarge\",\n    \"series\": \"sarge\",\n    \"created\": \"2002-07-19\",\n    \"release\": \"2005-06-06\",\n    \"eol\": \"2008-03-31\"\n  },\n  \"v4\": {\n    \"codename\": \"Etch\",\n    \"series\": \"etch\",\n    \"created\": \"2005-06-06\",\n    \"release\": \"2007-04-08\",\n    \"eol\": \"2010-02-15\"\n  },\n  \"v5\": {\n    \"codename\": \"Lenny\",\n    \"series\": \"lenny\",\n    \"created\": \"2007-04-08\",\n    \"release\": \"2009-02-14\",\n    \"eol\": \"2012-02-06\"\n  },\n  \"v6\": {\n    \"codename\": \"Squeeze\",\n    \"series\": \"squeeze\",\n    \"created\": \"2009-02-14\",\n    \"release\": \"2011-02-06\",\n    \"eol\": \"2014-05-31\",\n    \"eol_lts\": \"2016-02-29\"\n  },\n  \"v7\": {\n    \"codename\": \"Wheezy\",\n    \"series\": \"wheezy\",\n    \"created\": \"2011-02-06\",\n    \"release\": \"2013-05-04\",\n    \"eol\": \"2016-04-25\",\n    \"eol_lts\": \"2018-05-31\",\n    \"eol_elts\": \"2020-06-30\"\n  },\n  \"v8\": {\n    \"codename\": \"Jessie\",\n    \"series\": \"jessie\",\n    \"created\": \"2013-05-04\",\n    \"release\": \"2015-04-26\",\n    \"eol\": \"2018-06-17\",\n    \"eol_lts\": \"2020-06-30\",\n    \"eol_elts\": \"2025-06-30\"\n  },\n  \"v9\": {\n    \"codename\": \"Stretch\",\n    \"series\": \"stretch\",\n    \"created\": \"2015-04-26\",\n    \"release\": \"2017-06-17\",\n    \"eol\": \"2020-07-18\",\n    \"eol_lts\": \"2022-06-30\",\n    \"eol_elts\": \"2027-06-30\"\n  },\n  \"v10\": {\n    \"codename\": \"Buster\",\n    \"series\": \"buster\",\n    \"created\": \"2017-06-17\",\n    \"release\": \"2019-07-06\",\n    \"eol\": \"2022-09-10\",\n    \"eol_lts\": \"2024-06-30\",\n    \"eol_elts\": \"2029-06-30\"\n  },\n  \"v11\": {\n    \"codename\": \"Bullseye\",\n    \"series\": \"bullseye\",\n    \"created\": \"2019-07-06\",\n    \"release\": \"2021-08-14\",\n    \"eol\": \"2024-08-14\",\n    \"eol_lts\": \"2026-08-31\",\n    \"eol_elts\": \"2031-06-30\"\n  },\n  \"v12\": {\n    \"codename\": \"Bookworm\",\n    \"series\": \"bookworm\",\n    \"created\": \"2021-08-14\",\n    \"release\": \"2023-06-10\",\n    \"eol\": \"2026-06-10\",\n    \"eol_lts\": \"2028-06-30\",\n    \"eol_elts\": \"2033-06-30\"\n  },\n  \"v13\": {\n    \"codename\": \"Trixie\",\n    \"series\": \"trixie\",\n    \"created\": \"2023-06-10\"\n  },\n  \"v14\": {\n    \"codename\": \"Forky\",\n    \"series\": \"forky\",\n    \"created\": \"2025-08-01\"\n  },\n  \"v15\": {\n    \"codename\": \"Duke\",\n    \"series\": \"duke\",\n    \"created\": \"2027-08-01\"\n  }\n}\n");
data.set('data/kubernetes-api.json5', "{\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#v1-16\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#networkpolicy-v116\n  NetworkPolicy: ['extensions/v1beta1', 'networking.k8s.io/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#daemonset-v116\n  DaemonSet: ['extensions/v1beta1', 'apps/v1beta2', 'apps/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#deployment-v116\n  Deployment: ['extensions/v1beta1', 'apps/v1beta1', 'apps/v1beta2', 'apps/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#statefulset-v116\n  StatefulSet: ['apps/v1beta1', 'apps/v1beta2', 'apps/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#replicaset-v116\n  ReplicaSet: ['extensions/v1beta1', 'apps/v1beta1', 'apps/v1beta2', 'apps/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#psp-v116\n  PodSecurityPolicy: ['extensions/v1beta1', 'policy/v1beta1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#v1-22\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#webhook-resources-v122\n  MutatingWebhookConfiguration: [\n    'admissionregistration.k8s.io/v1beta1',\n    'admissionregistration.k8s.io/v1',\n  ],\n  ValidatingWebhookConfiguration: [\n    'admissionregistration.k8s.io/v1beta1',\n    'admissionregistration.k8s.io/v1',\n  ],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#customresourcedefinition-v122\n  CustomResourceDefinition: [\n    'apiextensions.k8s.io/v1beta1',\n    'apiextensions.k8s.io/v1',\n  ],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#apiservice-v122\n  APIService: ['apiregistration.k8s.io/v1beta1', 'apiregistration.k8s.io/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#tokenreview-v122\n  TokenReview: ['authentication.k8s.io/v1beta1', 'authentication.k8s.io/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#subjectaccessreview-resources-v122\n  LocalSubjectAccessReview: [\n    'authorization.k8s.io/v1beta1',\n    'authorization.k8s.io/v1',\n  ],\n  SelfSubjectAccessReview: [\n    'authorization.k8s.io/v1beta1',\n    'authorization.k8s.io/v1',\n  ],\n  SubjectAccessReview: [\n    'authorization.k8s.io/v1beta1',\n    'authorization.k8s.io/v1',\n  ],\n  SelfSubjectRulesReview: [\n    'authorization.k8s.io/v1beta1',\n    'authorization.k8s.io/v1',\n  ],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#certificatesigningrequest-v122\n  CertificateSigningRequest: [\n    'certificates.k8s.io/v1beta1',\n    'certificates.k8s.io/v1',\n  ],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#lease-v122\n  Lease: ['coordination.k8s.io/v1beta1', 'coordination.k8s.io/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#ingress-v122\n  Ingress: [\n    'extensions/v1beta1',\n    'networking.k8s.io/v1beta1',\n    'networking.k8s.io/v1',\n  ],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#ingressclass-v122\n  IngressClass: ['networking.k8s.io/v1beta1', 'networking.k8s.io/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#rbac-resources-v122\n  ClusterRole: [\n    'rbac.authorization.k8s.io/v1beta1',\n    'rbac.authorization.k8s.io/v1',\n  ],\n  ClusterRoleBinding: [\n    'rbac.authorization.k8s.io/v1beta1',\n    'rbac.authorization.k8s.io/v1',\n  ],\n  Role: ['rbac.authorization.k8s.io/v1beta1', 'rbac.authorization.k8s.io/v1'],\n  RoleBinding: [\n    'rbac.authorization.k8s.io/v1beta1',\n    'rbac.authorization.k8s.io/v1',\n  ],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#priorityclass-v122\n  PriorityClass: ['scheduling.k8s.io/v1beta1', 'scheduling.k8s.io/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#storage-resources-v122\n  CSIDriver: ['storage.k8s.io/v1beta1', 'storage.k8s.io/v1'],\n  CSINode: ['storage.k8s.io/v1beta1', 'storage.k8s.io/v1'],\n  StorageClass: ['storage.k8s.io/v1beta1', 'storage.k8s.io/v1'],\n  VolumeAttachment: ['storage.k8s.io/v1beta1', 'storage.k8s.io/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#v1-25\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#cronjob-v125\n  CronJob: ['batch/v1beta1', 'batch/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#endpointslice-v125\n  EndpointSlice: ['discovery.k8s.io/v1beta1', 'discovery.k8s.io/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#event-v125\n  Event: ['events.k8s.io/v1beta1', 'events.k8s.io/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#horizontalpodautoscaler-v125\n  HorizontalPodAutoscaler: ['autoscaling/v2beta1', 'autoscaling/v2'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#poddisruptionbudget-v125\n  PodDisruptionBudget: ['policy/v1beta1', 'policy/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#runtimeclass-v125\n  RuntimeClass: ['node.k8s.io/v1beta1', 'node.k8s.io/v1'],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#v1-26\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#flowcontrol-resources-v126\n  FlowSchema: [\n    'flowcontrol.apiserver.k8s.io/v1beta1',\n    'flowcontrol.apiserver.k8s.io/v1beta2',\n  ],\n  PriorityLevelConfiguration: [\n    'flowcontrol.apiserver.k8s.io/v1beta1',\n    'flowcontrol.apiserver.k8s.io/v1beta2',\n  ],\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#v1-27\n  // https://kubernetes.io/docs/reference/using-api/deprecation-guide/#csistoragecapacity-v127\n  CSIStorageCapacity: ['storage.k8s.io/v1beta1', 'storage.k8s.io/v1'],\n\n  // https://fluxcd.io\n  Alert: [\n    'notification.toolkit.fluxcd.io/v1beta2',\n    'notification.toolkit.fluxcd.io/v1beta3',\n  ],\n  Bucket: [\n    'source.toolkit.fluxcd.io/v1alpha1',\n    'source.toolkit.fluxcd.io/v1beta1',\n    'source.toolkit.fluxcd.io/v1beta2',\n    'source.toolkit.fluxcd.io/v1',\n  ],\n  GitRepository: [\n    'source.toolkit.fluxcd.io/v1alpha1',\n    'source.toolkit.fluxcd.io/v1beta1',\n    'source.toolkit.fluxcd.io/v1beta2',\n    'source.toolkit.fluxcd.io/v1',\n  ],\n  HelmChart: [\n    'source.toolkit.fluxcd.io/v1alpha1',\n    'source.toolkit.fluxcd.io/v1beta1',\n    'source.toolkit.fluxcd.io/v1',\n  ],\n  HelmRelease: [\n    'helm.toolkit.fluxcd.io/v2beta1',\n    'helm.toolkit.fluxcd.io/v2beta2',\n    'helm.toolkit.fluxcd.io/v2',\n  ],\n  HelmRepository: [\n    'source.toolkit.fluxcd.io/v1alpha1',\n    'source.toolkit.fluxcd.io/v1beta1',\n    'source.toolkit.fluxcd.io/v1beta2',\n    'source.toolkit.fluxcd.io/v1',\n  ],\n  ImagePolicy: ['image.toolkit.fluxcd.io/v1beta2'],\n  ImageRepository: ['image.toolkit.fluxcd.io/v1beta2'],\n  ImageUpdateAutomation: [\n    'image.toolkit.fluxcd.io/v1beta1',\n    'image.toolkit.fluxcd.io/v1beta2',\n  ],\n  OCIRepository: [\n    'source.toolkit.fluxcd.io/v1beta2',\n    'source.toolkit.fluxcd.io/v1',\n  ],\n  Provider: [\n    'notification.toolkit.fluxcd.io/v1beta2',\n    'notification.toolkit.fluxcd.io/v1beta3',\n  ],\n  Receiver: [\n    'notification.toolkit.fluxcd.io/v1beta2',\n    'notification.toolkit.fluxcd.io/v1',\n  ],\n\n  // https://fluxcd.io/flux/components/kustomize/kustomizations\n  // https://kubectl.docs.kubernetes.io/references/kustomize/kustomization\n  Kustomization: [\n    'kustomize.toolkit.fluxcd.io/v1beta2',\n    'kustomize.toolkit.fluxcd.io/v1',\n    'kustomize.config.k8s.io/v1beta1',\n  ],\n\n  // https://external-secrets.io/latest/api/spec/\n  ExternalSecret: [\n    'external-secrets.io/v1alpha1',\n    'external-secrets.io/v1beta1',\n    'external-secrets.io/v1',\n  ],\n  ClusterExternalSecret: [\n    'external-secrets.io/v1alpha1',\n    'external-secrets.io/v1beta1',\n    'external-secrets.io/v1',\n  ],\n  SecretStore: [\n    'external-secrets.io/v1alpha1',\n    'external-secrets.io/v1beta1',\n    'external-secrets.io/v1',\n  ],\n  ClusterSecretStore: [\n    'external-secrets.io/v1alpha1',\n    'external-secrets.io/v1beta1',\n    'external-secrets.io/v1',\n  ],\n}\n");
data.set('data/lambda-node-js-schedule.json', "{\n  \"10\": {\n    \"cycle\": \"nodejs10.x\",\n    \"support\": \"2021-07-30\"\n  },\n  \"12\": {\n    \"cycle\": \"nodejs12.x\",\n    \"support\": \"2023-03-31\"\n  },\n  \"14\": {\n    \"cycle\": \"nodejs14.x\",\n    \"support\": \"2023-12-04\"\n  },\n  \"16\": {\n    \"cycle\": \"nodejs16.x\",\n    \"support\": \"2024-06-12\"\n  },\n  \"18\": {\n    \"cycle\": \"nodejs18.x\",\n    \"support\": \"2025-09-01\"\n  },\n  \"20\": {\n    \"cycle\": \"nodejs20.x\",\n    \"support\": \"2026-04-30\"\n  },\n  \"22\": {\n    \"cycle\": \"nodejs22.x\",\n    \"support\": \"2027-04-30\"\n  }\n}\n");
data.set('data/node-js-schedule.json', "{\n  \"v0.8\": {\n    \"start\": \"2012-06-25\",\n    \"end\": \"2014-07-31\"\n  },\n  \"v0.10\": {\n    \"start\": \"2013-03-11\",\n    \"end\": \"2016-10-31\"\n  },\n  \"v0.12\": {\n    \"start\": \"2015-02-06\",\n    \"end\": \"2016-12-31\"\n  },\n  \"v4\": {\n    \"start\": \"2015-09-08\",\n    \"lts\": \"2015-10-12\",\n    \"maintenance\": \"2017-04-01\",\n    \"end\": \"2018-04-30\",\n    \"codename\": \"Argon\"\n  },\n  \"v5\": {\n    \"start\": \"2015-10-29\",\n    \"maintenance\": \"2016-04-30\",\n    \"end\": \"2016-06-30\"\n  },\n  \"v6\": {\n    \"start\": \"2016-04-26\",\n    \"lts\": \"2016-10-18\",\n    \"maintenance\": \"2018-04-30\",\n    \"end\": \"2019-04-30\",\n    \"codename\": \"Boron\"\n  },\n  \"v7\": {\n    \"start\": \"2016-10-25\",\n    \"maintenance\": \"2017-04-30\",\n    \"end\": \"2017-06-30\"\n  },\n  \"v8\": {\n    \"start\": \"2017-05-30\",\n    \"lts\": \"2017-10-31\",\n    \"maintenance\": \"2019-01-01\",\n    \"end\": \"2019-12-31\",\n    \"codename\": \"Carbon\"\n  },\n  \"v9\": {\n    \"start\": \"2017-10-01\",\n    \"maintenance\": \"2018-04-01\",\n    \"end\": \"2018-06-30\"\n  },\n  \"v10\": {\n    \"start\": \"2018-04-24\",\n    \"lts\": \"2018-10-30\",\n    \"maintenance\": \"2020-05-19\",\n    \"end\": \"2021-04-30\",\n    \"codename\": \"Dubnium\"\n  },\n  \"v11\": {\n    \"start\": \"2018-10-23\",\n    \"maintenance\": \"2019-04-22\",\n    \"end\": \"2019-06-01\"\n  },\n  \"v12\": {\n    \"start\": \"2019-04-23\",\n    \"lts\": \"2019-10-21\",\n    \"maintenance\": \"2020-11-30\",\n    \"end\": \"2022-04-30\",\n    \"codename\": \"Erbium\"\n  },\n  \"v13\": {\n    \"start\": \"2019-10-22\",\n    \"maintenance\": \"2020-04-01\",\n    \"end\": \"2020-06-01\"\n  },\n  \"v14\": {\n    \"start\": \"2020-04-21\",\n    \"lts\": \"2020-10-27\",\n    \"maintenance\": \"2021-10-19\",\n    \"end\": \"2023-04-30\",\n    \"codename\": \"Fermium\"\n  },\n  \"v15\": {\n    \"start\": \"2020-10-20\",\n    \"maintenance\": \"2021-04-01\",\n    \"end\": \"2021-06-01\"\n  },\n  \"v16\": {\n    \"start\": \"2021-04-20\",\n    \"lts\": \"2021-10-26\",\n    \"maintenance\": \"2022-10-18\",\n    \"end\": \"2023-09-11\",\n    \"codename\": \"Gallium\"\n  },\n  \"v17\": {\n    \"start\": \"2021-10-19\",\n    \"maintenance\": \"2022-04-01\",\n    \"end\": \"2022-06-01\"\n  },\n  \"v18\": {\n    \"start\": \"2022-04-19\",\n    \"lts\": \"2022-10-25\",\n    \"maintenance\": \"2023-10-18\",\n    \"end\": \"2025-04-30\",\n    \"codename\": \"Hydrogen\"\n  },\n  \"v19\": {\n    \"start\": \"2022-10-18\",\n    \"maintenance\": \"2023-04-01\",\n    \"end\": \"2023-06-01\"\n  },\n  \"v20\": {\n    \"start\": \"2023-04-18\",\n    \"lts\": \"2023-10-24\",\n    \"maintenance\": \"2024-10-22\",\n    \"end\": \"2026-04-30\",\n    \"codename\": \"Iron\"\n  },\n  \"v21\": {\n    \"start\": \"2023-10-17\",\n    \"maintenance\": \"2024-04-01\",\n    \"end\": \"2024-06-01\"\n  },\n  \"v22\": {\n    \"start\": \"2024-04-24\",\n    \"lts\": \"2024-10-29\",\n    \"maintenance\": \"2025-10-21\",\n    \"end\": \"2027-04-30\",\n    \"codename\": \"Jod\"\n  },\n  \"v23\": {\n    \"start\": \"2024-10-16\",\n    \"maintenance\": \"2025-04-01\",\n    \"end\": \"2025-06-01\"\n  },\n  \"v24\": {\n    \"start\": \"2025-05-06\",\n    \"lts\": \"2025-10-28\",\n    \"maintenance\": \"2026-10-20\",\n    \"end\": \"2028-04-30\",\n    \"codename\": \"\"\n  },\n  \"v25\": {\n    \"start\": \"2025-10-15\",\n    \"maintenance\": \"2026-04-01\",\n    \"end\": \"2026-06-01\"\n  },\n  \"v26\": {\n    \"start\": \"2026-04-22\",\n    \"lts\": \"2026-10-28\",\n    \"maintenance\": \"2027-10-20\",\n    \"end\": \"2029-04-30\",\n    \"codename\": \"\"\n  }\n}\n");
data.set('data/ubuntu-distro-info.json', "{\n  \"v4.10\": {\n    \"codename\": \"Warty Warthog\",\n    \"series\": \"warty\",\n    \"created\": \"2004-03-05\",\n    \"release\": \"2004-10-20\",\n    \"eol\": \"2006-04-30\"\n  },\n  \"v5.04\": {\n    \"codename\": \"Hoary Hedgehog\",\n    \"series\": \"hoary\",\n    \"created\": \"2004-10-20\",\n    \"release\": \"2005-04-08\",\n    \"eol\": \"2006-10-31\"\n  },\n  \"v5.10\": {\n    \"codename\": \"Breezy Badger\",\n    \"series\": \"breezy\",\n    \"created\": \"2005-04-08\",\n    \"release\": \"2005-10-12\",\n    \"eol\": \"2007-04-13\"\n  },\n  \"v6.06\": {\n    \"codename\": \"Dapper Drake\",\n    \"series\": \"dapper\",\n    \"created\": \"2005-10-12\",\n    \"release\": \"2006-06-01\",\n    \"eol\": \"2009-07-14\",\n    \"eol_server\": \"2011-06-01\"\n  },\n  \"v6.10\": {\n    \"codename\": \"Edgy Eft\",\n    \"series\": \"edgy\",\n    \"created\": \"2006-06-01\",\n    \"release\": \"2006-10-26\",\n    \"eol\": \"2008-04-25\"\n  },\n  \"v7.04\": {\n    \"codename\": \"Feisty Fawn\",\n    \"series\": \"feisty\",\n    \"created\": \"2006-10-26\",\n    \"release\": \"2007-04-19\",\n    \"eol\": \"2008-10-19\"\n  },\n  \"v7.10\": {\n    \"codename\": \"Gutsy Gibbon\",\n    \"series\": \"gutsy\",\n    \"created\": \"2007-04-19\",\n    \"release\": \"2007-10-18\",\n    \"eol\": \"2009-04-18\"\n  },\n  \"v8.04\": {\n    \"codename\": \"Hardy Heron\",\n    \"series\": \"hardy\",\n    \"created\": \"2007-10-18\",\n    \"release\": \"2008-04-24\",\n    \"eol\": \"2011-05-12\",\n    \"eol_server\": \"2013-05-09\"\n  },\n  \"v8.10\": {\n    \"codename\": \"Intrepid Ibex\",\n    \"series\": \"intrepid\",\n    \"created\": \"2008-04-24\",\n    \"release\": \"2008-10-30\",\n    \"eol\": \"2010-04-30\"\n  },\n  \"v9.04\": {\n    \"codename\": \"Jaunty Jackalope\",\n    \"series\": \"jaunty\",\n    \"created\": \"2008-10-30\",\n    \"release\": \"2009-04-23\",\n    \"eol\": \"2010-10-23\"\n  },\n  \"v9.10\": {\n    \"codename\": \"Karmic Koala\",\n    \"series\": \"karmic\",\n    \"created\": \"2009-04-23\",\n    \"release\": \"2009-10-29\",\n    \"eol\": \"2011-04-30\"\n  },\n  \"v10.04\": {\n    \"codename\": \"Lucid Lynx\",\n    \"series\": \"lucid\",\n    \"created\": \"2009-10-29\",\n    \"release\": \"2010-04-29\",\n    \"eol\": \"2013-05-09\",\n    \"eol_server\": \"2015-04-30\"\n  },\n  \"v10.10\": {\n    \"codename\": \"Maverick Meerkat\",\n    \"series\": \"maverick\",\n    \"created\": \"2010-04-29\",\n    \"release\": \"2010-10-10\",\n    \"eol\": \"2012-04-10\"\n  },\n  \"v11.04\": {\n    \"codename\": \"Natty Narwhal\",\n    \"series\": \"natty\",\n    \"created\": \"2010-10-10\",\n    \"release\": \"2011-04-28\",\n    \"eol\": \"2012-10-28\"\n  },\n  \"v11.10\": {\n    \"codename\": \"Oneiric Ocelot\",\n    \"series\": \"oneiric\",\n    \"created\": \"2011-04-28\",\n    \"release\": \"2011-10-13\",\n    \"eol\": \"2013-05-09\"\n  },\n  \"v12.04\": {\n    \"codename\": \"Precise Pangolin\",\n    \"series\": \"precise\",\n    \"created\": \"2011-10-13\",\n    \"release\": \"2012-04-26\",\n    \"eol\": \"2017-04-28\",\n    \"eol_server\": \"2017-04-28\",\n    \"eol_esm\": \"2019-04-26\"\n  },\n  \"v12.10\": {\n    \"codename\": \"Quantal Quetzal\",\n    \"series\": \"quantal\",\n    \"created\": \"2012-04-26\",\n    \"release\": \"2012-10-18\",\n    \"eol\": \"2014-05-16\"\n  },\n  \"v13.04\": {\n    \"codename\": \"Raring Ringtail\",\n    \"series\": \"raring\",\n    \"created\": \"2012-10-18\",\n    \"release\": \"2013-04-25\",\n    \"eol\": \"2014-01-27\"\n  },\n  \"v13.10\": {\n    \"codename\": \"Saucy Salamander\",\n    \"series\": \"saucy\",\n    \"created\": \"2013-04-25\",\n    \"release\": \"2013-10-17\",\n    \"eol\": \"2014-07-17\"\n  },\n  \"v14.04\": {\n    \"codename\": \"Trusty Tahr\",\n    \"series\": \"trusty\",\n    \"created\": \"2013-10-17\",\n    \"release\": \"2014-04-17\",\n    \"eol\": \"2019-04-25\",\n    \"eol_server\": \"2019-04-25\",\n    \"eol_esm\": \"2024-04-25\"\n  },\n  \"v14.10\": {\n    \"codename\": \"Utopic Unicorn\",\n    \"series\": \"utopic\",\n    \"created\": \"2014-04-17\",\n    \"release\": \"2014-10-23\",\n    \"eol\": \"2015-07-23\"\n  },\n  \"v15.04\": {\n    \"codename\": \"Vivid Vervet\",\n    \"series\": \"vivid\",\n    \"created\": \"2014-10-23\",\n    \"release\": \"2015-04-23\",\n    \"eol\": \"2016-02-04\"\n  },\n  \"v15.10\": {\n    \"codename\": \"Wily Werewolf\",\n    \"series\": \"wily\",\n    \"created\": \"2015-04-23\",\n    \"release\": \"2015-10-22\",\n    \"eol\": \"2016-07-28\"\n  },\n  \"v16.04\": {\n    \"codename\": \"Xenial Xerus\",\n    \"series\": \"xenial\",\n    \"created\": \"2015-10-22\",\n    \"release\": \"2016-04-21\",\n    \"eol\": \"2021-04-30\",\n    \"eol_server\": \"2021-04-30\",\n    \"eol_esm\": \"2026-04-23\"\n  },\n  \"v16.10\": {\n    \"codename\": \"Yakkety Yak\",\n    \"series\": \"yakkety\",\n    \"created\": \"2016-04-21\",\n    \"release\": \"2016-10-13\",\n    \"eol\": \"2017-07-20\"\n  },\n  \"v17.04\": {\n    \"codename\": \"Zesty Zapus\",\n    \"series\": \"zesty\",\n    \"created\": \"2016-10-13\",\n    \"release\": \"2017-04-13\",\n    \"eol\": \"2018-01-13\"\n  },\n  \"v17.10\": {\n    \"codename\": \"Artful Aardvark\",\n    \"series\": \"artful\",\n    \"created\": \"2017-04-13\",\n    \"release\": \"2017-10-19\",\n    \"eol\": \"2018-07-19\"\n  },\n  \"v18.04\": {\n    \"codename\": \"Bionic Beaver\",\n    \"series\": \"bionic\",\n    \"created\": \"2017-10-19\",\n    \"release\": \"2018-04-26\",\n    \"eol\": \"2023-05-31\",\n    \"eol_server\": \"2023-05-31\",\n    \"eol_esm\": \"2028-04-26\"\n  },\n  \"v18.10\": {\n    \"codename\": \"Cosmic Cuttlefish\",\n    \"series\": \"cosmic\",\n    \"created\": \"2018-04-26\",\n    \"release\": \"2018-10-18\",\n    \"eol\": \"2019-07-18\"\n  },\n  \"v19.04\": {\n    \"codename\": \"Disco Dingo\",\n    \"series\": \"disco\",\n    \"created\": \"2018-10-18\",\n    \"release\": \"2019-04-18\",\n    \"eol\": \"2020-01-23\"\n  },\n  \"v19.10\": {\n    \"codename\": \"Eoan Ermine\",\n    \"series\": \"eoan\",\n    \"created\": \"2019-04-18\",\n    \"release\": \"2019-10-17\",\n    \"eol\": \"2020-07-17\"\n  },\n  \"v20.04\": {\n    \"codename\": \"Focal Fossa\",\n    \"series\": \"focal\",\n    \"created\": \"2019-10-17\",\n    \"release\": \"2020-04-23\",\n    \"eol\": \"2025-05-29\",\n    \"eol_server\": \"2025-05-29\",\n    \"eol_esm\": \"2030-04-23\"\n  },\n  \"v20.10\": {\n    \"codename\": \"Groovy Gorilla\",\n    \"series\": \"groovy\",\n    \"created\": \"2020-04-23\",\n    \"release\": \"2020-10-22\",\n    \"eol\": \"2021-07-22\"\n  },\n  \"v21.04\": {\n    \"codename\": \"Hirsute Hippo\",\n    \"series\": \"hirsute\",\n    \"created\": \"2020-10-22\",\n    \"release\": \"2021-04-22\",\n    \"eol\": \"2022-01-20\"\n  },\n  \"v21.10\": {\n    \"codename\": \"Impish Indri\",\n    \"series\": \"impish\",\n    \"created\": \"2021-04-22\",\n    \"release\": \"2021-10-14\",\n    \"eol\": \"2022-07-14\"\n  },\n  \"v22.04\": {\n    \"codename\": \"Jammy Jellyfish\",\n    \"series\": \"jammy\",\n    \"created\": \"2021-10-14\",\n    \"release\": \"2022-04-21\",\n    \"eol\": \"2027-06-01\",\n    \"eol_server\": \"2027-06-01\",\n    \"eol_esm\": \"2032-04-21\"\n  },\n  \"v22.10\": {\n    \"codename\": \"Kinetic Kudu\",\n    \"series\": \"kinetic\",\n    \"created\": \"2022-04-21\",\n    \"release\": \"2022-10-20\",\n    \"eol\": \"2023-07-20\"\n  },\n  \"v23.04\": {\n    \"codename\": \"Lunar Lobster\",\n    \"series\": \"lunar\",\n    \"created\": \"2022-10-20\",\n    \"release\": \"2023-04-20\",\n    \"eol\": \"2024-01-25\"\n  },\n  \"v23.10\": {\n    \"codename\": \"Mantic Minotaur\",\n    \"series\": \"mantic\",\n    \"created\": \"2023-04-20\",\n    \"release\": \"2023-10-12\",\n    \"eol\": \"2024-07-11\"\n  },\n  \"v24.04\": {\n    \"codename\": \"Noble Numbat\",\n    \"series\": \"noble\",\n    \"created\": \"2023-10-12\",\n    \"release\": \"2024-04-25\",\n    \"eol\": \"2029-05-31\",\n    \"eol_server\": \"2029-05-31\",\n    \"eol_esm\": \"2034-04-25\"\n  },\n  \"v24.10\": {\n    \"codename\": \"Oracular Oriole\",\n    \"series\": \"oracular\",\n    \"created\": \"2024-04-25\",\n    \"release\": \"2024-10-10\",\n    \"eol\": \"2025-07-10\"\n  },\n  \"v25.04\": {\n    \"codename\": \"Plucky Puffin\",\n    \"series\": \"plucky\",\n    \"created\": \"2024-10-10\",\n    \"release\": \"2025-04-17\",\n    \"eol\": \"2026-01-15\"\n  },\n  \"v25.10\": {\n    \"codename\": \"Questing Quokka\",\n    \"series\": \"questing\",\n    \"created\": \"2025-04-17\",\n    \"release\": \"2025-10-09\",\n    \"eol\": \"2026-07-09\"\n  }\n}\n");
data.set('node_modules/emojibase-data/en/shortcodes/github.json', "{\"2049\":\"interrobang\",\"2122\":\"tm\",\"2139\":\"information_source\",\"2194\":\"left_right_arrow\",\"2195\":\"arrow_up_down\",\"2196\":\"arrow_upper_left\",\"2197\":\"arrow_upper_right\",\"2198\":\"arrow_lower_right\",\"2199\":\"arrow_lower_left\",\"2328\":\"keyboard\",\"2600\":\"sunny\",\"2601\":\"cloud\",\"2602\":\"open_umbrella\",\"2603\":\"snowman_with_snow\",\"2604\":\"comet\",\"2611\":\"ballot_box_with_check\",\"2614\":\"umbrella\",\"2615\":\"coffee\",\"2618\":\"shamrock\",\"2620\":\"skull_and_crossbones\",\"2622\":\"radioactive\",\"2623\":\"biohazard\",\"2626\":\"orthodox_cross\",\"2638\":\"wheel_of_dharma\",\"2639\":\"frowning_face\",\"2640\":\"female_sign\",\"2642\":\"male_sign\",\"2648\":\"aries\",\"2649\":\"taurus\",\"2650\":\"sagittarius\",\"2651\":\"capricorn\",\"2652\":\"aquarius\",\"2653\":\"pisces\",\"2660\":\"spades\",\"2663\":\"clubs\",\"2665\":\"hearts\",\"2666\":\"diamonds\",\"2668\":\"hotsprings\",\"2692\":\"hammer_and_pick\",\"2693\":\"anchor\",\"2694\":\"crossed_swords\",\"2695\":\"medical_symbol\",\"2696\":\"balance_scale\",\"2697\":\"alembic\",\"2699\":\"gear\",\"2702\":\"scissors\",\"2705\":\"white_check_mark\",\"2708\":\"airplane\",\"2709\":\"envelope\",\"2712\":\"black_nib\",\"2714\":\"heavy_check_mark\",\"2716\":\"heavy_multiplication_x\",\"2721\":\"star_of_david\",\"2728\":\"sparkles\",\"2733\":\"eight_spoked_asterisk\",\"2734\":\"eight_pointed_black_star\",\"2744\":\"snowflake\",\"2747\":\"sparkle\",\"2753\":\"question\",\"2754\":\"grey_question\",\"2755\":\"grey_exclamation\",\"2757\":[\"exclamation\",\"heavy_exclamation_mark\"],\"2763\":\"heavy_heart_exclamation\",\"2764\":\"heart\",\"2795\":\"heavy_plus_sign\",\"2796\":\"heavy_minus_sign\",\"2797\":\"heavy_division_sign\",\"2934\":\"arrow_heading_up\",\"2935\":\"arrow_heading_down\",\"3030\":\"wavy_dash\",\"3297\":\"congratulations\",\"3299\":\"secret\",\"1F4AF\":\"100\",\"1F522\":\"1234\",\"1F44D\":[\"+1\",\"thumbsup\"],\"1F44E\":[\"-1\",\"thumbsdown\"],\"1F947\":\"1st_place_medal\",\"1F948\":\"2nd_place_medal\",\"1F949\":\"3rd_place_medal\",\"1F3B1\":\"8ball\",\"1F170\":\"a\",\"1F18E\":\"ab\",\"1F9EE\":\"abacus\",\"1F524\":\"abc\",\"1F521\":\"abcd\",\"1F251\":\"accept\",\"1FA97\":\"accordion\",\"1FA79\":\"adhesive_bandage\",\"1F9D1\":\"adult\",\"1F6A1\":\"aerial_tramway\",\"1F1E6-1F1EB\":\"afghanistan\",\"1F1E6-1F1FD\":\"aland_islands\",\"23F0\":\"alarm_clock\",\"1F1E6-1F1F1\":\"albania\",\"1F1E9-1F1FF\":\"algeria\",\"1F47D\":\"alien\",\"1F691\":\"ambulance\",\"1F1E6-1F1F8\":\"american_samoa\",\"1F3FA\":\"amphora\",\"1FAC0\":\"anatomical_heart\",\"1F1E6-1F1E9\":\"andorra\",\"1F47C\":\"angel\",\"1F4A2\":\"anger\",\"1F1E6-1F1F4\":\"angola\",\"1F620\":\"angry\",\"1F1E6-1F1EE\":\"anguilla\",\"1F627\":\"anguished\",\"1F41C\":\"ant\",\"1F1E6-1F1F6\":\"antarctica\",\"1F1E6-1F1EC\":\"antigua_barbuda\",\"1F34E\":\"apple\",\"1F1E6-1F1F7\":\"argentina\",\"1F1E6-1F1F2\":\"armenia\",\"25C0\":\"arrow_backward\",\"23EC\":\"arrow_double_down\",\"23EB\":\"arrow_double_up\",\"2B07\":\"arrow_down\",\"1F53D\":\"arrow_down_small\",\"25B6\":\"arrow_forward\",\"2B05\":\"arrow_left\",\"27A1\":\"arrow_right\",\"21AA\":\"arrow_right_hook\",\"2B06\":\"arrow_up\",\"1F53C\":\"arrow_up_small\",\"1F503\":\"arrows_clockwise\",\"1F504\":\"arrows_counterclockwise\",\"1F3A8\":\"art\",\"1F69B\":\"articulated_lorry\",\"1F6F0\":\"artificial_satellite\",\"1F9D1-200D-1F3A8\":\"artist\",\"1F1E6-1F1FC\":\"aruba\",\"1F1E6-1F1E8\":\"ascension_island\",\"002A-FE0F-20E3\":\"asterisk\",\"1F632\":\"astonished\",\"1F9D1-200D-1F680\":\"astronaut\",\"1F45F\":\"athletic_shoe\",\"1F3E7\":\"atm\",\"269B\":\"atom_symbol\",\"1F1E6-1F1FA\":\"australia\",\"1F1E6-1F1F9\":\"austria\",\"1F6FA\":\"auto_rickshaw\",\"1F951\":\"avocado\",\"1FA93\":\"axe\",\"1F1E6-1F1FF\":\"azerbaijan\",\"1F171\":\"b\",\"1F476\":\"baby\",\"1F37C\":\"baby_bottle\",\"1F424\":\"baby_chick\",\"1F6BC\":\"baby_symbol\",\"1F519\":\"back\",\"1F953\":\"bacon\",\"1F9A1\":\"badger\",\"1F3F8\":\"badminton\",\"1F96F\":\"bagel\",\"1F6C4\":\"baggage_claim\",\"1F956\":\"baguette_bread\",\"1F1E7-1F1F8\":\"bahamas\",\"1F1E7-1F1ED\":\"bahrain\",\"1F468-200D-1F9B2\":\"bald_man\",\"1F469-200D-1F9B2\":\"bald_woman\",\"1FA70\":\"ballet_shoes\",\"1F388\":\"balloon\",\"1F5F3\":\"ballot_box\",\"1F38D\":\"bamboo\",\"1F34C\":\"banana\",\"203C\":\"bangbang\",\"1F1E7-1F1E9\":\"bangladesh\",\"1FA95\":\"banjo\",\"1F3E6\":\"bank\",\"1F4CA\":\"bar_chart\",\"1F1E7-1F1E7\":\"barbados\",\"1F488\":\"barber\",\"26BE\":\"baseball\",\"1F9FA\":\"basket\",\"1F3C0\":\"basketball\",\"26F9-FE0F-200D-2642-FE0F\":[\"basketball_man\",\"bouncing_ball_man\"],\"26F9-FE0F-200D-2640-FE0F\":[\"basketball_woman\",\"bouncing_ball_woman\"],\"1F987\":\"bat\",\"1F6C0\":\"bath\",\"1F6C1\":\"bathtub\",\"1F50B\":\"battery\",\"1F3D6\":\"beach_umbrella\",\"1FAD8\":\"beans\",\"1F43B\":\"bear\",\"1F9D4\":\"bearded_person\",\"1F9AB\":\"beaver\",\"1F6CF\":\"bed\",\"1F41D\":[\"bee\",\"honeybee\"],\"1F37A\":\"beer\",\"1F37B\":\"beers\",\"1FAB2\":\"beetle\",\"1F530\":\"beginner\",\"1F1E7-1F1FE\":\"belarus\",\"1F1E7-1F1EA\":\"belgium\",\"1F1E7-1F1FF\":\"belize\",\"1F514\":\"bell\",\"1FAD1\":\"bell_pepper\",\"1F6CE\":\"bellhop_bell\",\"1F1E7-1F1EF\":\"benin\",\"1F371\":\"bento\",\"1F1E7-1F1F2\":\"bermuda\",\"1F9C3\":\"beverage_box\",\"1F1E7-1F1F9\":\"bhutan\",\"1F6B4\":\"bicyclist\",\"1F6B2\":\"bike\",\"1F6B4-200D-2642-FE0F\":\"biking_man\",\"1F6B4-200D-2640-FE0F\":\"biking_woman\",\"1F459\":\"bikini\",\"1F9E2\":\"billed_cap\",\"1F426\":\"bird\",\"1F382\":\"birthday\",\"1F9AC\":\"bison\",\"1FAE6\":\"biting_lip\",\"1F426-200D-2B1B\":\"black_bird\",\"1F408-200D-2B1B\":\"black_cat\",\"26AB\":\"black_circle\",\"1F3F4\":\"black_flag\",\"1F5A4\":\"black_heart\",\"1F0CF\":\"black_joker\",\"2B1B\":\"black_large_square\",\"25FE\":\"black_medium_small_square\",\"25FC\":\"black_medium_square\",\"25AA\":\"black_small_square\",\"1F532\":\"black_square_button\",\"1F471-200D-2642-FE0F\":\"blond_haired_man\",\"1F471\":\"blond_haired_person\",\"1F471-200D-2640-FE0F\":[\"blond_haired_woman\",\"blonde_woman\"],\"1F33C\":\"blossom\",\"1F421\":\"blowfish\",\"1F4D8\":\"blue_book\",\"1F699\":\"blue_car\",\"1F499\":\"blue_heart\",\"1F7E6\":\"blue_square\",\"1FAD0\":\"blueberries\",\"1F60A\":\"blush\",\"1F417\":\"boar\",\"26F5\":[\"boat\",\"sailboat\"],\"1F1E7-1F1F4\":\"bolivia\",\"1F4A3\":\"bomb\",\"1F9B4\":\"bone\",\"1F4D6\":[\"book\",\"open_book\"],\"1F516\":\"bookmark\",\"1F4D1\":\"bookmark_tabs\",\"1F4DA\":\"books\",\"1F4A5\":[\"boom\",\"collision\"],\"1FA83\":\"boomerang\",\"1F462\":\"boot\",\"1F1E7-1F1E6\":\"bosnia_herzegovina\",\"1F1E7-1F1FC\":\"botswana\",\"26F9\":\"bouncing_ball_person\",\"1F490\":\"bouquet\",\"1F1E7-1F1FB\":\"bouvet_island\",\"1F647\":\"bow\",\"1F3F9\":\"bow_and_arrow\",\"1F647-200D-2642-FE0F\":\"bowing_man\",\"1F647-200D-2640-FE0F\":\"bowing_woman\",\"1F963\":\"bowl_with_spoon\",\"1F3B3\":\"bowling\",\"1F94A\":\"boxing_glove\",\"1F466\":\"boy\",\"1F9E0\":\"brain\",\"1F1E7-1F1F7\":\"brazil\",\"1F35E\":\"bread\",\"1F931\":\"breast_feeding\",\"1F9F1\":\"bricks\",\"1F470-200D-2640-FE0F\":[\"bride_with_veil\",\"woman_with_veil\"],\"1F309\":\"bridge_at_night\",\"1F4BC\":\"briefcase\",\"1F1EE-1F1F4\":\"british_indian_ocean_territory\",\"1F1FB-1F1EC\":\"british_virgin_islands\",\"1F966\":\"broccoli\",\"1F494\":\"broken_heart\",\"1F9F9\":\"broom\",\"1F7E4\":\"brown_circle\",\"1F90E\":\"brown_heart\",\"1F7EB\":\"brown_square\",\"1F1E7-1F1F3\":\"brunei\",\"1F9CB\":\"bubble_tea\",\"1FAE7\":\"bubbles\",\"1FAA3\":\"bucket\",\"1F41B\":\"bug\",\"1F3D7\":\"building_construction\",\"1F4A1\":\"bulb\",\"1F1E7-1F1EC\":\"bulgaria\",\"1F685\":\"bullettrain_front\",\"1F684\":\"bullettrain_side\",\"1F1E7-1F1EB\":\"burkina_faso\",\"1F32F\":\"burrito\",\"1F1E7-1F1EE\":\"burundi\",\"1F68C\":\"bus\",\"1F574\":\"business_suit_levitating\",\"1F68F\":\"busstop\",\"1F464\":\"bust_in_silhouette\",\"1F465\":\"busts_in_silhouette\",\"1F9C8\":\"butter\",\"1F98B\":\"butterfly\",\"1F335\":\"cactus\",\"1F370\":\"cake\",\"1F4C6\":\"calendar\",\"1F919\":\"call_me_hand\",\"1F4F2\":\"calling\",\"1F1F0-1F1ED\":\"cambodia\",\"1F42B\":\"camel\",\"1F4F7\":\"camera\",\"1F4F8\":\"camera_flash\",\"1F1E8-1F1F2\":\"cameroon\",\"1F3D5\":\"camping\",\"1F1E8-1F1E6\":\"canada\",\"1F1EE-1F1E8\":\"canary_islands\",\"264B\":\"cancer\",\"1F56F\":\"candle\",\"1F36C\":\"candy\",\"1F96B\":\"canned_food\",\"1F6F6\":\"canoe\",\"1F1E8-1F1FB\":\"cape_verde\",\"1F520\":\"capital_abcd\",\"1F697\":[\"car\",\"red_car\"],\"1F5C3\":\"card_file_box\",\"1F4C7\":\"card_index\",\"1F5C2\":\"card_index_dividers\",\"1F1E7-1F1F6\":\"caribbean_netherlands\",\"1F3A0\":\"carousel_horse\",\"1FA9A\":\"carpentry_saw\",\"1F955\":\"carrot\",\"1F938\":\"cartwheeling\",\"1F431\":\"cat\",\"1F408\":\"cat2\",\"1F1F0-1F1FE\":\"cayman_islands\",\"1F4BF\":\"cd\",\"1F1E8-1F1EB\":\"central_african_republic\",\"1F1EA-1F1E6\":\"ceuta_melilla\",\"1F1F9-1F1E9\":\"chad\",\"26D3\":\"chains\",\"1FA91\":\"chair\",\"1F37E\":\"champagne\",\"1F4B9\":\"chart\",\"1F4C9\":\"chart_with_downwards_trend\",\"1F4C8\":\"chart_with_upwards_trend\",\"1F3C1\":\"checkered_flag\",\"1F9C0\":\"cheese\",\"1F352\":\"cherries\",\"1F338\":\"cherry_blossom\",\"265F\":\"chess_pawn\",\"1F330\":\"chestnut\",\"1F414\":\"chicken\",\"1F9D2\":\"child\",\"1F6B8\":\"children_crossing\",\"1F1E8-1F1F1\":\"chile\",\"1F43F\":\"chipmunk\",\"1F36B\":\"chocolate_bar\",\"1F962\":\"chopsticks\",\"1F1E8-1F1FD\":\"christmas_island\",\"1F384\":\"christmas_tree\",\"26EA\":\"church\",\"1F3A6\":\"cinema\",\"1F3AA\":\"circus_tent\",\"1F307\":\"city_sunrise\",\"1F306\":\"city_sunset\",\"1F3D9\":\"cityscape\",\"1F191\":\"cl\",\"1F5DC\":\"clamp\",\"1F44F\":\"clap\",\"1F3AC\":\"clapper\",\"1F3DB\":\"classical_building\",\"1F9D7\":\"climbing\",\"1F9D7-200D-2642-FE0F\":\"climbing_man\",\"1F9D7-200D-2640-FE0F\":\"climbing_woman\",\"1F942\":\"clinking_glasses\",\"1F4CB\":\"clipboard\",\"1F1E8-1F1F5\":\"clipperton_island\",\"1F550\":\"clock1\",\"1F559\":\"clock10\",\"1F565\":\"clock1030\",\"1F55A\":\"clock11\",\"1F566\":\"clock1130\",\"1F55B\":\"clock12\",\"1F567\":\"clock1230\",\"1F55C\":\"clock130\",\"1F551\":\"clock2\",\"1F55D\":\"clock230\",\"1F552\":\"clock3\",\"1F55E\":\"clock330\",\"1F553\":\"clock4\",\"1F55F\":\"clock430\",\"1F554\":\"clock5\",\"1F560\":\"clock530\",\"1F555\":\"clock6\",\"1F561\":\"clock630\",\"1F556\":\"clock7\",\"1F562\":\"clock730\",\"1F557\":\"clock8\",\"1F563\":\"clock830\",\"1F558\":\"clock9\",\"1F564\":\"clock930\",\"1F4D5\":\"closed_book\",\"1F510\":\"closed_lock_with_key\",\"1F302\":\"closed_umbrella\",\"1F329\":\"cloud_with_lightning\",\"26C8\":\"cloud_with_lightning_and_rain\",\"1F327\":\"cloud_with_rain\",\"1F328\":\"cloud_with_snow\",\"1F921\":\"clown_face\",\"1F1E8-1F1F3\":\"cn\",\"1F9E5\":\"coat\",\"1FAB3\":\"cockroach\",\"1F378\":\"cocktail\",\"1F965\":\"coconut\",\"1F1E8-1F1E8\":\"cocos_islands\",\"26B0\":\"coffin\",\"1FA99\":\"coin\",\"1F976\":\"cold_face\",\"1F630\":\"cold_sweat\",\"1F1E8-1F1F4\":\"colombia\",\"1F1F0-1F1F2\":\"comoros\",\"1F9ED\":\"compass\",\"1F4BB\":\"computer\",\"1F5B1\":\"computer_mouse\",\"1F38A\":\"confetti_ball\",\"1F616\":\"confounded\",\"1F615\":\"confused\",\"1F1E8-1F1EC\":\"congo_brazzaville\",\"1F1E8-1F1E9\":\"congo_kinshasa\",\"1F6A7\":\"construction\",\"1F477\":\"construction_worker\",\"1F477-200D-2642-FE0F\":\"construction_worker_man\",\"1F477-200D-2640-FE0F\":\"construction_worker_woman\",\"1F39B\":\"control_knobs\",\"1F3EA\":\"convenience_store\",\"1F9D1-200D-1F373\":\"cook\",\"1F1E8-1F1F0\":\"cook_islands\",\"1F36A\":\"cookie\",\"1F192\":\"cool\",\"1F46E\":[\"cop\",\"police_officer\"],\"00A9\":\"copyright\",\"1FAB8\":\"coral\",\"1F33D\":\"corn\",\"1F1E8-1F1F7\":\"costa_rica\",\"1F1E8-1F1EE\":\"cote_divoire\",\"1F6CB\":\"couch_and_lamp\",\"1F46B\":\"couple\",\"1F491\":\"couple_with_heart\",\"1F468-200D-2764-FE0F-200D-1F468\":\"couple_with_heart_man_man\",\"1F469-200D-2764-FE0F-200D-1F468\":\"couple_with_heart_woman_man\",\"1F469-200D-2764-FE0F-200D-1F469\":\"couple_with_heart_woman_woman\",\"1F48F\":\"couplekiss\",\"1F468-200D-2764-FE0F-200D-1F48B-200D-1F468\":\"couplekiss_man_man\",\"1F469-200D-2764-FE0F-200D-1F48B-200D-1F468\":\"couplekiss_man_woman\",\"1F469-200D-2764-FE0F-200D-1F48B-200D-1F469\":\"couplekiss_woman_woman\",\"1F42E\":\"cow\",\"1F404\":\"cow2\",\"1F920\":\"cowboy_hat_face\",\"1F980\":\"crab\",\"1F58D\":\"crayon\",\"1F4B3\":\"credit_card\",\"1F319\":\"crescent_moon\",\"1F997\":\"cricket\",\"1F3CF\":\"cricket_game\",\"1F1ED-1F1F7\":\"croatia\",\"1F40A\":\"crocodile\",\"1F950\":\"croissant\",\"1F91E\":\"crossed_fingers\",\"1F38C\":\"crossed_flags\",\"1F451\":\"crown\",\"1FA7C\":\"crutch\",\"1F622\":\"cry\",\"1F63F\":\"crying_cat_face\",\"1F52E\":\"crystal_ball\",\"1F1E8-1F1FA\":\"cuba\",\"1F952\":\"cucumber\",\"1F964\":\"cup_with_straw\",\"1F9C1\":\"cupcake\",\"1F498\":\"cupid\",\"1F1E8-1F1FC\":\"curacao\",\"1F94C\":\"curling_stone\",\"1F468-200D-1F9B1\":\"curly_haired_man\",\"1F469-200D-1F9B1\":\"curly_haired_woman\",\"27B0\":\"curly_loop\",\"1F4B1\":\"currency_exchange\",\"1F35B\":\"curry\",\"1F92C\":\"cursing_face\",\"1F36E\":\"custard\",\"1F6C3\":\"customs\",\"1F969\":\"cut_of_meat\",\"1F300\":\"cyclone\",\"1F1E8-1F1FE\":\"cyprus\",\"1F1E8-1F1FF\":\"czech_republic\",\"1F5E1\":\"dagger\",\"1F483\":[\"dancer\",\"woman_dancing\"],\"1F46F\":\"dancers\",\"1F46F-200D-2642-FE0F\":\"dancing_men\",\"1F46F-200D-2640-FE0F\":\"dancing_women\",\"1F361\":\"dango\",\"1F576\":\"dark_sunglasses\",\"1F3AF\":\"dart\",\"1F4A8\":\"dash\",\"1F4C5\":\"date\",\"1F1E9-1F1EA\":\"de\",\"1F9CF-200D-2642-FE0F\":\"deaf_man\",\"1F9CF\":\"deaf_person\",\"1F9CF-200D-2640-FE0F\":\"deaf_woman\",\"1F333\":\"deciduous_tree\",\"1F98C\":\"deer\",\"1F1E9-1F1F0\":\"denmark\",\"1F3EC\":\"department_store\",\"1F3DA\":\"derelict_house\",\"1F3DC\":\"desert\",\"1F3DD\":\"desert_island\",\"1F5A5\":\"desktop_computer\",\"1F575\":\"detective\",\"1F4A0\":\"diamond_shape_with_a_dot_inside\",\"1F1E9-1F1EC\":\"diego_garcia\",\"1F61E\":\"disappointed\",\"1F625\":\"disappointed_relieved\",\"1F978\":\"disguised_face\",\"1F93F\":\"diving_mask\",\"1FA94\":\"diya_lamp\",\"1F4AB\":\"dizzy\",\"1F635\":\"dizzy_face\",\"1F1E9-1F1EF\":\"djibouti\",\"1F9EC\":\"dna\",\"1F6AF\":\"do_not_litter\",\"1F9A4\":\"dodo\",\"1F436\":\"dog\",\"1F415\":\"dog2\",\"1F4B5\":\"dollar\",\"1F38E\":\"dolls\",\"1F42C\":[\"dolphin\",\"flipper\"],\"1F1E9-1F1F2\":\"dominica\",\"1F1E9-1F1F4\":\"dominican_republic\",\"1FACF\":\"donkey\",\"1F6AA\":\"door\",\"1FAE5\":\"dotted_line_face\",\"1F369\":\"doughnut\",\"1F54A\":\"dove\",\"1F409\":\"dragon\",\"1F432\":\"dragon_face\",\"1F457\":\"dress\",\"1F42A\":\"dromedary_camel\",\"1F924\":\"drooling_face\",\"1FA78\":\"drop_of_blood\",\"1F4A7\":\"droplet\",\"1F941\":\"drum\",\"1F986\":\"duck\",\"1F95F\":\"dumpling\",\"1F4C0\":\"dvd\",\"1F4E7\":[\"e-mail\",\"email\"],\"1F985\":\"eagle\",\"1F442\":\"ear\",\"1F33E\":\"ear_of_rice\",\"1F9BB\":\"ear_with_hearing_aid\",\"1F30D\":\"earth_africa\",\"1F30E\":\"earth_americas\",\"1F30F\":\"earth_asia\",\"1F1EA-1F1E8\":\"ecuador\",\"1F95A\":\"egg\",\"1F346\":\"eggplant\",\"1F1EA-1F1EC\":\"egypt\",\"0038-FE0F-20E3\":\"eight\",\"23CF\":\"eject_button\",\"1F1F8-1F1FB\":\"el_salvador\",\"1F50C\":\"electric_plug\",\"1F418\":\"elephant\",\"1F6D7\":\"elevator\",\"1F9DD\":\"elf\",\"1F9DD-200D-2642-FE0F\":\"elf_man\",\"1F9DD-200D-2640-FE0F\":\"elf_woman\",\"1FAB9\":\"empty_nest\",\"1F51A\":\"end\",\"1F3F4-E0067-E0062-E0065-E006E-E0067-E007F\":\"england\",\"1F4E9\":\"envelope_with_arrow\",\"1F1EC-1F1F6\":\"equatorial_guinea\",\"1F1EA-1F1F7\":\"eritrea\",\"1F1EA-1F1F8\":\"es\",\"1F1EA-1F1EA\":\"estonia\",\"1F1EA-1F1F9\":\"ethiopia\",\"1F1EA-1F1FA\":[\"eu\",\"european_union\"],\"1F4B6\":\"euro\",\"1F3F0\":\"european_castle\",\"1F3E4\":\"european_post_office\",\"1F332\":\"evergreen_tree\",\"1F92F\":\"exploding_head\",\"1F611\":\"expressionless\",\"1F441\":\"eye\",\"1F441-FE0F-200D-1F5E8-FE0F\":\"eye_speech_bubble\",\"1F453\":\"eyeglasses\",\"1F440\":\"eyes\",\"1F62E-200D-1F4A8\":\"face_exhaling\",\"1F979\":\"face_holding_back_tears\",\"1F636-200D-1F32B-FE0F\":\"face_in_clouds\",\"1FAE4\":\"face_with_diagonal_mouth\",\"1F915\":\"face_with_head_bandage\",\"1FAE2\":\"face_with_open_eyes_and_hand_over_mouth\",\"1FAE3\":\"face_with_peeking_eye\",\"1F635-200D-1F4AB\":\"face_with_spiral_eyes\",\"1F912\":\"face_with_thermometer\",\"1F926\":\"facepalm\",\"1F44A\":[\"facepunch\",\"fist_oncoming\",\"punch\"],\"1F3ED\":\"factory\",\"1F9D1-200D-1F3ED\":\"factory_worker\",\"1F9DA\":\"fairy\",\"1F9DA-200D-2642-FE0F\":\"fairy_man\",\"1F9DA-200D-2640-FE0F\":\"fairy_woman\",\"1F9C6\":\"falafel\",\"1F1EB-1F1F0\":\"falkland_islands\",\"1F342\":\"fallen_leaf\",\"1F46A\":\"family\",\"1F468-200D-1F466\":\"family_man_boy\",\"1F468-200D-1F466-200D-1F466\":\"family_man_boy_boy\",\"1F468-200D-1F467\":\"family_man_girl\",\"1F468-200D-1F467-200D-1F466\":\"family_man_girl_boy\",\"1F468-200D-1F467-200D-1F467\":\"family_man_girl_girl\",\"1F468-200D-1F468-200D-1F466\":\"family_man_man_boy\",\"1F468-200D-1F468-200D-1F466-200D-1F466\":\"family_man_man_boy_boy\",\"1F468-200D-1F468-200D-1F467\":\"family_man_man_girl\",\"1F468-200D-1F468-200D-1F467-200D-1F466\":\"family_man_man_girl_boy\",\"1F468-200D-1F468-200D-1F467-200D-1F467\":\"family_man_man_girl_girl\",\"1F468-200D-1F469-200D-1F466\":\"family_man_woman_boy\",\"1F468-200D-1F469-200D-1F466-200D-1F466\":\"family_man_woman_boy_boy\",\"1F468-200D-1F469-200D-1F467\":\"family_man_woman_girl\",\"1F468-200D-1F469-200D-1F467-200D-1F466\":\"family_man_woman_girl_boy\",\"1F468-200D-1F469-200D-1F467-200D-1F467\":\"family_man_woman_girl_girl\",\"1F469-200D-1F466\":\"family_woman_boy\",\"1F469-200D-1F466-200D-1F466\":\"family_woman_boy_boy\",\"1F469-200D-1F467\":\"family_woman_girl\",\"1F469-200D-1F467-200D-1F466\":\"family_woman_girl_boy\",\"1F469-200D-1F467-200D-1F467\":\"family_woman_girl_girl\",\"1F469-200D-1F469-200D-1F466\":\"family_woman_woman_boy\",\"1F469-200D-1F469-200D-1F466-200D-1F466\":\"family_woman_woman_boy_boy\",\"1F469-200D-1F469-200D-1F467\":\"family_woman_woman_girl\",\"1F469-200D-1F469-200D-1F467-200D-1F466\":\"family_woman_woman_girl_boy\",\"1F469-200D-1F469-200D-1F467-200D-1F467\":\"family_woman_woman_girl_girl\",\"1F9D1-200D-1F33E\":\"farmer\",\"1F1EB-1F1F4\":\"faroe_islands\",\"23E9\":\"fast_forward\",\"1F4E0\":\"fax\",\"1F628\":\"fearful\",\"1FAB6\":\"feather\",\"1F43E\":[\"feet\",\"paw_prints\"],\"1F575-FE0F-200D-2640-FE0F\":\"female_detective\",\"1F3A1\":\"ferris_wheel\",\"26F4\":\"ferry\",\"1F3D1\":\"field_hockey\",\"1F1EB-1F1EF\":\"fiji\",\"1F5C4\":\"file_cabinet\",\"1F4C1\":\"file_folder\",\"1F4FD\":\"film_projector\",\"1F39E\":\"film_strip\",\"1F1EB-1F1EE\":\"finland\",\"1F525\":\"fire\",\"1F692\":\"fire_engine\",\"1F9EF\":\"fire_extinguisher\",\"1F9E8\":\"firecracker\",\"1F9D1-200D-1F692\":\"firefighter\",\"1F386\":\"fireworks\",\"1F313\":\"first_quarter_moon\",\"1F31B\":\"first_quarter_moon_with_face\",\"1F41F\":\"fish\",\"1F365\":\"fish_cake\",\"1F3A3\":\"fishing_pole_and_fish\",\"270A\":[\"fist\",\"fist_raised\"],\"1F91B\":\"fist_left\",\"1F91C\":\"fist_right\",\"0035-FE0F-20E3\":\"five\",\"1F38F\":\"flags\",\"1F9A9\":\"flamingo\",\"1F526\":\"flashlight\",\"1F97F\":\"flat_shoe\",\"1FAD3\":\"flatbread\",\"269C\":\"fleur_de_lis\",\"1F6EC\":\"flight_arrival\",\"1F6EB\":\"flight_departure\",\"1F4BE\":\"floppy_disk\",\"1F3B4\":\"flower_playing_cards\",\"1F633\":\"flushed\",\"1FA88\":\"flute\",\"1FAB0\":\"fly\",\"1F94F\":\"flying_disc\",\"1F6F8\":\"flying_saucer\",\"1F32B\":\"fog\",\"1F301\":\"foggy\",\"1FAAD\":\"folding_hand_fan\",\"1FAD5\":\"fondue\",\"1F9B6\":\"foot\",\"1F3C8\":\"football\",\"1F463\":\"footprints\",\"1F374\":\"fork_and_knife\",\"1F960\":\"fortune_cookie\",\"26F2\":\"fountain\",\"1F58B\":\"fountain_pen\",\"0034-FE0F-20E3\":\"four\",\"1F340\":\"four_leaf_clover\",\"1F98A\":\"fox_face\",\"1F1EB-1F1F7\":\"fr\",\"1F5BC\":\"framed_picture\",\"1F193\":\"free\",\"1F1EC-1F1EB\":\"french_guiana\",\"1F1F5-1F1EB\":\"french_polynesia\",\"1F1F9-1F1EB\":\"french_southern_territories\",\"1F373\":\"fried_egg\",\"1F364\":\"fried_shrimp\",\"1F35F\":\"fries\",\"1F438\":\"frog\",\"1F626\":\"frowning\",\"1F64D-200D-2642-FE0F\":\"frowning_man\",\"1F64D\":\"frowning_person\",\"1F64D-200D-2640-FE0F\":\"frowning_woman\",\"1F595\":[\"fu\",\"middle_finger\"],\"26FD\":\"fuelpump\",\"1F315\":\"full_moon\",\"1F31D\":\"full_moon_with_face\",\"26B1\":\"funeral_urn\",\"1F1EC-1F1E6\":\"gabon\",\"1F1EC-1F1F2\":\"gambia\",\"1F3B2\":\"game_die\",\"1F9C4\":\"garlic\",\"1F1EC-1F1E7\":[\"gb\",\"uk\"],\"1F48E\":\"gem\",\"264A\":\"gemini\",\"1F9DE\":\"genie\",\"1F9DE-200D-2642-FE0F\":\"genie_man\",\"1F9DE-200D-2640-FE0F\":\"genie_woman\",\"1F1EC-1F1EA\":\"georgia\",\"1F1EC-1F1ED\":\"ghana\",\"1F47B\":\"ghost\",\"1F1EC-1F1EE\":\"gibraltar\",\"1F381\":\"gift\",\"1F49D\":\"gift_heart\",\"1FADA\":\"ginger_root\",\"1F992\":\"giraffe\",\"1F467\":\"girl\",\"1F310\":\"globe_with_meridians\",\"1F9E4\":\"gloves\",\"1F945\":\"goal_net\",\"1F410\":\"goat\",\"1F97D\":\"goggles\",\"26F3\":\"golf\",\"1F3CC\":\"golfing\",\"1F3CC-FE0F-200D-2642-FE0F\":\"golfing_man\",\"1F3CC-FE0F-200D-2640-FE0F\":\"golfing_woman\",\"1FABF\":\"goose\",\"1F98D\":\"gorilla\",\"1F347\":\"grapes\",\"1F1EC-1F1F7\":\"greece\",\"1F34F\":\"green_apple\",\"1F4D7\":\"green_book\",\"1F7E2\":\"green_circle\",\"1F49A\":\"green_heart\",\"1F957\":\"green_salad\",\"1F7E9\":\"green_square\",\"1F1EC-1F1F1\":\"greenland\",\"1F1EC-1F1E9\":\"grenada\",\"1FA76\":\"grey_heart\",\"1F62C\":\"grimacing\",\"1F601\":\"grin\",\"1F600\":\"grinning\",\"1F1EC-1F1F5\":\"guadeloupe\",\"1F1EC-1F1FA\":\"guam\",\"1F482\":\"guard\",\"1F482-200D-2642-FE0F\":\"guardsman\",\"1F482-200D-2640-FE0F\":\"guardswoman\",\"1F1EC-1F1F9\":\"guatemala\",\"1F1EC-1F1EC\":\"guernsey\",\"1F9AE\":\"guide_dog\",\"1F1EC-1F1F3\":\"guinea\",\"1F1EC-1F1FC\":\"guinea_bissau\",\"1F3B8\":\"guitar\",\"1F52B\":\"gun\",\"1F1EC-1F1FE\":\"guyana\",\"1FAAE\":\"hair_pick\",\"1F487\":\"haircut\",\"1F487-200D-2642-FE0F\":\"haircut_man\",\"1F487-200D-2640-FE0F\":\"haircut_woman\",\"1F1ED-1F1F9\":\"haiti\",\"1F354\":\"hamburger\",\"1F528\":\"hammer\",\"1F6E0\":\"hammer_and_wrench\",\"1FAAC\":\"hamsa\",\"1F439\":\"hamster\",\"270B\":[\"hand\",\"raised_hand\"],\"1F92D\":\"hand_over_mouth\",\"1FAF0\":\"hand_with_index_finger_and_thumb_crossed\",\"1F45C\":\"handbag\",\"1F93E\":\"handball_person\",\"1F91D\":\"handshake\",\"1F4A9\":[\"hankey\",\"poop\",\"shit\"],\"0023-FE0F-20E3\":\"hash\",\"1F425\":\"hatched_chick\",\"1F423\":\"hatching_chick\",\"1F3A7\":\"headphones\",\"1FAA6\":\"headstone\",\"1F9D1-200D-2695-FE0F\":\"health_worker\",\"1F649\":\"hear_no_evil\",\"1F1ED-1F1F2\":\"heard_mcdonald_islands\",\"1F49F\":\"heart_decoration\",\"1F60D\":\"heart_eyes\",\"1F63B\":\"heart_eyes_cat\",\"1FAF6\":\"heart_hands\",\"2764-FE0F-200D-1F525\":\"heart_on_fire\",\"1F493\":\"heartbeat\",\"1F497\":\"heartpulse\",\"1F4B2\":\"heavy_dollar_sign\",\"1F7F0\":\"heavy_equals_sign\",\"1F994\":\"hedgehog\",\"1F681\":\"helicopter\",\"1F33F\":\"herb\",\"1F33A\":\"hibiscus\",\"1F506\":\"high_brightness\",\"1F460\":\"high_heel\",\"1F97E\":\"hiking_boot\",\"1F6D5\":\"hindu_temple\",\"1F99B\":\"hippopotamus\",\"1F52A\":[\"hocho\",\"knife\"],\"1F573\":\"hole\",\"1F1ED-1F1F3\":\"honduras\",\"1F36F\":\"honey_pot\",\"1F1ED-1F1F0\":\"hong_kong\",\"1FA9D\":\"hook\",\"1F434\":\"horse\",\"1F3C7\":\"horse_racing\",\"1F3E5\":\"hospital\",\"1F975\":\"hot_face\",\"1F336\":\"hot_pepper\",\"1F32D\":\"hotdog\",\"1F3E8\":\"hotel\",\"231B\":\"hourglass\",\"23F3\":\"hourglass_flowing_sand\",\"1F3E0\":\"house\",\"1F3E1\":\"house_with_garden\",\"1F3D8\":\"houses\",\"1F917\":\"hugs\",\"1F1ED-1F1FA\":\"hungary\",\"1F62F\":\"hushed\",\"1F6D6\":\"hut\",\"1FABB\":\"hyacinth\",\"1F368\":\"ice_cream\",\"1F9CA\":\"ice_cube\",\"1F3D2\":\"ice_hockey\",\"26F8\":\"ice_skate\",\"1F366\":\"icecream\",\"1F1EE-1F1F8\":\"iceland\",\"1F194\":\"id\",\"1FAAA\":\"identification_card\",\"1F250\":\"ideograph_advantage\",\"1F47F\":\"imp\",\"1F4E5\":\"inbox_tray\",\"1F4E8\":\"incoming_envelope\",\"1FAF5\":\"index_pointing_at_the_viewer\",\"1F1EE-1F1F3\":\"india\",\"1F1EE-1F1E9\":\"indonesia\",\"267E\":\"infinity\",\"1F481\":[\"information_desk_person\",\"tipping_hand_person\"],\"1F607\":\"innocent\",\"1F4F1\":\"iphone\",\"1F1EE-1F1F7\":\"iran\",\"1F1EE-1F1F6\":\"iraq\",\"1F1EE-1F1EA\":\"ireland\",\"1F1EE-1F1F2\":\"isle_of_man\",\"1F1EE-1F1F1\":\"israel\",\"1F1EE-1F1F9\":\"it\",\"1F3EE\":[\"izakaya_lantern\",\"lantern\"],\"1F383\":\"jack_o_lantern\",\"1F1EF-1F1F2\":\"jamaica\",\"1F5FE\":\"japan\",\"1F3EF\":\"japanese_castle\",\"1F47A\":\"japanese_goblin\",\"1F479\":\"japanese_ogre\",\"1FAD9\":\"jar\",\"1F456\":\"jeans\",\"1FABC\":\"jellyfish\",\"1F1EF-1F1EA\":\"jersey\",\"1F9E9\":\"jigsaw\",\"1F1EF-1F1F4\":\"jordan\",\"1F602\":\"joy\",\"1F639\":\"joy_cat\",\"1F579\":\"joystick\",\"1F1EF-1F1F5\":\"jp\",\"1F9D1-200D-2696-FE0F\":\"judge\",\"1F939\":\"juggling_person\",\"1F54B\":\"kaaba\",\"1F998\":\"kangaroo\",\"1F1F0-1F1FF\":\"kazakhstan\",\"1F1F0-1F1EA\":\"kenya\",\"1F511\":\"key\",\"1F51F\":\"keycap_ten\",\"1FAAF\":\"khanda\",\"1F6F4\":\"kick_scooter\",\"1F458\":\"kimono\",\"1F1F0-1F1EE\":\"kiribati\",\"1F48B\":\"kiss\",\"1F617\":\"kissing\",\"1F63D\":\"kissing_cat\",\"1F61A\":\"kissing_closed_eyes\",\"1F618\":\"kissing_heart\",\"1F619\":\"kissing_smiling_eyes\",\"1FA81\":\"kite\",\"1F95D\":\"kiwi_fruit\",\"1F9CE-200D-2642-FE0F\":\"kneeling_man\",\"1F9CE\":\"kneeling_person\",\"1F9CE-200D-2640-FE0F\":\"kneeling_woman\",\"1FAA2\":\"knot\",\"1F428\":\"koala\",\"1F201\":\"koko\",\"1F1FD-1F1F0\":\"kosovo\",\"1F1F0-1F1F7\":\"kr\",\"1F1F0-1F1FC\":\"kuwait\",\"1F1F0-1F1EC\":\"kyrgyzstan\",\"1F97C\":\"lab_coat\",\"1F3F7\":\"label\",\"1F94D\":\"lacrosse\",\"1FA9C\":\"ladder\",\"1F41E\":\"lady_beetle\",\"1F1F1-1F1E6\":\"laos\",\"1F535\":\"large_blue_circle\",\"1F537\":\"large_blue_diamond\",\"1F536\":\"large_orange_diamond\",\"1F317\":\"last_quarter_moon\",\"1F31C\":\"last_quarter_moon_with_face\",\"271D\":\"latin_cross\",\"1F1F1-1F1FB\":\"latvia\",\"1F606\":[\"laughing\",\"satisfied\"],\"1F96C\":\"leafy_green\",\"1F343\":\"leaves\",\"1F1F1-1F1E7\":\"lebanon\",\"1F4D2\":\"ledger\",\"1F6C5\":\"left_luggage\",\"1F5E8\":\"left_speech_bubble\",\"21A9\":\"leftwards_arrow_with_hook\",\"1FAF2\":\"leftwards_hand\",\"1FAF7\":\"leftwards_pushing_hand\",\"1F9B5\":\"leg\",\"1F34B\":\"lemon\",\"264C\":\"leo\",\"1F406\":\"leopard\",\"1F1F1-1F1F8\":\"lesotho\",\"1F39A\":\"level_slider\",\"1F1F1-1F1F7\":\"liberia\",\"264E\":\"libra\",\"1F1F1-1F1FE\":\"libya\",\"1F1F1-1F1EE\":\"liechtenstein\",\"1FA75\":\"light_blue_heart\",\"1F688\":\"light_rail\",\"1F517\":\"link\",\"1F981\":\"lion\",\"1F444\":\"lips\",\"1F484\":\"lipstick\",\"1F1F1-1F1F9\":\"lithuania\",\"1F98E\":\"lizard\",\"1F999\":\"llama\",\"1F99E\":\"lobster\",\"1F512\":\"lock\",\"1F50F\":\"lock_with_ink_pen\",\"1F36D\":\"lollipop\",\"1FA98\":\"long_drum\",\"27BF\":\"loop\",\"1F9F4\":\"lotion_bottle\",\"1FAB7\":\"lotus\",\"1F9D8\":\"lotus_position\",\"1F9D8-200D-2642-FE0F\":\"lotus_position_man\",\"1F9D8-200D-2640-FE0F\":\"lotus_position_woman\",\"1F50A\":\"loud_sound\",\"1F4E2\":\"loudspeaker\",\"1F3E9\":\"love_hotel\",\"1F48C\":\"love_letter\",\"1F91F\":\"love_you_gesture\",\"1FAAB\":\"low_battery\",\"1F505\":\"low_brightness\",\"1F9F3\":\"luggage\",\"1FAC1\":\"lungs\",\"1F1F1-1F1FA\":\"luxembourg\",\"1F925\":\"lying_face\",\"24C2\":\"m\",\"1F1F2-1F1F4\":\"macau\",\"1F1F2-1F1F0\":\"macedonia\",\"1F1F2-1F1EC\":\"madagascar\",\"1F50D\":\"mag\",\"1F50E\":\"mag_right\",\"1F9D9\":\"mage\",\"1F9D9-200D-2642-FE0F\":\"mage_man\",\"1F9D9-200D-2640-FE0F\":\"mage_woman\",\"1FA84\":\"magic_wand\",\"1F9F2\":\"magnet\",\"1F004\":\"mahjong\",\"1F4EB\":\"mailbox\",\"1F4EA\":\"mailbox_closed\",\"1F4EC\":\"mailbox_with_mail\",\"1F4ED\":\"mailbox_with_no_mail\",\"1F1F2-1F1FC\":\"malawi\",\"1F1F2-1F1FE\":\"malaysia\",\"1F1F2-1F1FB\":\"maldives\",\"1F575-FE0F-200D-2642-FE0F\":\"male_detective\",\"1F1F2-1F1F1\":\"mali\",\"1F1F2-1F1F9\":\"malta\",\"1F9A3\":\"mammoth\",\"1F468\":\"man\",\"1F468-200D-1F3A8\":\"man_artist\",\"1F468-200D-1F680\":\"man_astronaut\",\"1F9D4-200D-2642-FE0F\":\"man_beard\",\"1F938-200D-2642-FE0F\":\"man_cartwheeling\",\"1F468-200D-1F373\":\"man_cook\",\"1F57A\":\"man_dancing\",\"1F926-200D-2642-FE0F\":\"man_facepalming\",\"1F468-200D-1F3ED\":\"man_factory_worker\",\"1F468-200D-1F33E\":\"man_farmer\",\"1F468-200D-1F37C\":\"man_feeding_baby\",\"1F468-200D-1F692\":\"man_firefighter\",\"1F468-200D-2695-FE0F\":\"man_health_worker\",\"1F468-200D-1F9BD\":\"man_in_manual_wheelchair\",\"1F468-200D-1F9BC\":\"man_in_motorized_wheelchair\",\"1F935-200D-2642-FE0F\":\"man_in_tuxedo\",\"1F468-200D-2696-FE0F\":\"man_judge\",\"1F939-200D-2642-FE0F\":\"man_juggling\",\"1F468-200D-1F527\":\"man_mechanic\",\"1F468-200D-1F4BC\":\"man_office_worker\",\"1F468-200D-2708-FE0F\":\"man_pilot\",\"1F93E-200D-2642-FE0F\":\"man_playing_handball\",\"1F93D-200D-2642-FE0F\":\"man_playing_water_polo\",\"1F468-200D-1F52C\":\"man_scientist\",\"1F937-200D-2642-FE0F\":\"man_shrugging\",\"1F468-200D-1F3A4\":\"man_singer\",\"1F468-200D-1F393\":\"man_student\",\"1F468-200D-1F3EB\":\"man_teacher\",\"1F468-200D-1F4BB\":\"man_technologist\",\"1F472\":\"man_with_gua_pi_mao\",\"1F468-200D-1F9AF\":\"man_with_probing_cane\",\"1F473-200D-2642-FE0F\":\"man_with_turban\",\"1F470-200D-2642-FE0F\":\"man_with_veil\",\"1F34A\":[\"mandarin\",\"orange\",\"tangerine\"],\"1F96D\":\"mango\",\"1F45E\":[\"mans_shoe\",\"shoe\"],\"1F570\":\"mantelpiece_clock\",\"1F9BD\":\"manual_wheelchair\",\"1F341\":\"maple_leaf\",\"1FA87\":\"maracas\",\"1F1F2-1F1ED\":\"marshall_islands\",\"1F94B\":\"martial_arts_uniform\",\"1F1F2-1F1F6\":\"martinique\",\"1F637\":\"mask\",\"1F486\":\"massage\",\"1F486-200D-2642-FE0F\":\"massage_man\",\"1F486-200D-2640-FE0F\":\"massage_woman\",\"1F9C9\":\"mate\",\"1F1F2-1F1F7\":\"mauritania\",\"1F1F2-1F1FA\":\"mauritius\",\"1F1FE-1F1F9\":\"mayotte\",\"1F356\":\"meat_on_bone\",\"1F9D1-200D-1F527\":\"mechanic\",\"1F9BE\":\"mechanical_arm\",\"1F9BF\":\"mechanical_leg\",\"1F396\":\"medal_military\",\"1F3C5\":\"medal_sports\",\"1F4E3\":\"mega\",\"1F348\":\"melon\",\"1FAE0\":\"melting_face\",\"1F4DD\":[\"memo\",\"pencil\"],\"1F93C-200D-2642-FE0F\":\"men_wrestling\",\"2764-FE0F-200D-1FA79\":\"mending_heart\",\"1F54E\":\"menorah\",\"1F6B9\":\"mens\",\"1F9DC-200D-2640-FE0F\":\"mermaid\",\"1F9DC-200D-2642-FE0F\":\"merman\",\"1F9DC\":\"merperson\",\"1F918\":\"metal\",\"1F687\":\"metro\",\"1F1F2-1F1FD\":\"mexico\",\"1F9A0\":\"microbe\",\"1F1EB-1F1F2\":\"micronesia\",\"1F3A4\":\"microphone\",\"1F52C\":\"microscope\",\"1FA96\":\"military_helmet\",\"1F95B\":\"milk_glass\",\"1F30C\":\"milky_way\",\"1F690\":\"minibus\",\"1F4BD\":\"minidisc\",\"1FA9E\":\"mirror\",\"1FAA9\":\"mirror_ball\",\"1F4F4\":\"mobile_phone_off\",\"1F1F2-1F1E9\":\"moldova\",\"1F1F2-1F1E8\":\"monaco\",\"1F911\":\"money_mouth_face\",\"1F4B8\":\"money_with_wings\",\"1F4B0\":\"moneybag\",\"1F1F2-1F1F3\":\"mongolia\",\"1F412\":\"monkey\",\"1F435\":\"monkey_face\",\"1F9D0\":\"monocle_face\",\"1F69D\":\"monorail\",\"1F1F2-1F1EA\":\"montenegro\",\"1F1F2-1F1F8\":\"montserrat\",\"1F314\":[\"moon\",\"waxing_gibbous_moon\"],\"1F96E\":\"moon_cake\",\"1FACE\":\"moose\",\"1F1F2-1F1E6\":\"morocco\",\"1F393\":\"mortar_board\",\"1F54C\":\"mosque\",\"1F99F\":\"mosquito\",\"1F6E5\":\"motor_boat\",\"1F6F5\":\"motor_scooter\",\"1F3CD\":\"motorcycle\",\"1F9BC\":\"motorized_wheelchair\",\"1F6E3\":\"motorway\",\"1F5FB\":\"mount_fuji\",\"26F0\":\"mountain\",\"1F6B5\":\"mountain_bicyclist\",\"1F6B5-200D-2642-FE0F\":\"mountain_biking_man\",\"1F6B5-200D-2640-FE0F\":\"mountain_biking_woman\",\"1F6A0\":\"mountain_cableway\",\"1F69E\":\"mountain_railway\",\"1F3D4\":\"mountain_snow\",\"1F42D\":\"mouse\",\"1F401\":\"mouse2\",\"1FAA4\":\"mouse_trap\",\"1F3A5\":\"movie_camera\",\"1F5FF\":\"moyai\",\"1F1F2-1F1FF\":\"mozambique\",\"1F936\":\"mrs_claus\",\"1F4AA\":\"muscle\",\"1F344\":\"mushroom\",\"1F3B9\":\"musical_keyboard\",\"1F3B5\":\"musical_note\",\"1F3BC\":\"musical_score\",\"1F507\":\"mute\",\"1F9D1-200D-1F384\":\"mx_claus\",\"1F1F2-1F1F2\":\"myanmar\",\"1F485\":\"nail_care\",\"1F4DB\":\"name_badge\",\"1F1F3-1F1E6\":\"namibia\",\"1F3DE\":\"national_park\",\"1F1F3-1F1F7\":\"nauru\",\"1F922\":\"nauseated_face\",\"1F9FF\":\"nazar_amulet\",\"1F454\":\"necktie\",\"274E\":\"negative_squared_cross_mark\",\"1F1F3-1F1F5\":\"nepal\",\"1F913\":\"nerd_face\",\"1FABA\":\"nest_with_eggs\",\"1FA86\":\"nesting_dolls\",\"1F1F3-1F1F1\":\"netherlands\",\"1F610\":\"neutral_face\",\"1F195\":\"new\",\"1F1F3-1F1E8\":\"new_caledonia\",\"1F311\":\"new_moon\",\"1F31A\":\"new_moon_with_face\",\"1F1F3-1F1FF\":\"new_zealand\",\"1F4F0\":\"newspaper\",\"1F5DE\":\"newspaper_roll\",\"23ED\":\"next_track_button\",\"1F196\":\"ng\",\"1F645-200D-2642-FE0F\":[\"ng_man\",\"no_good_man\"],\"1F645-200D-2640-FE0F\":[\"ng_woman\",\"no_good_woman\"],\"1F1F3-1F1EE\":\"nicaragua\",\"1F1F3-1F1EA\":\"niger\",\"1F1F3-1F1EC\":\"nigeria\",\"1F303\":\"night_with_stars\",\"0039-FE0F-20E3\":\"nine\",\"1F977\":\"ninja\",\"1F1F3-1F1FA\":\"niue\",\"1F515\":\"no_bell\",\"1F6B3\":\"no_bicycles\",\"26D4\":\"no_entry\",\"1F6AB\":\"no_entry_sign\",\"1F645\":\"no_good\",\"1F4F5\":\"no_mobile_phones\",\"1F636\":\"no_mouth\",\"1F6B7\":\"no_pedestrians\",\"1F6AD\":\"no_smoking\",\"1F6B1\":\"non-potable_water\",\"1F1F3-1F1EB\":\"norfolk_island\",\"1F1F0-1F1F5\":\"north_korea\",\"1F1F2-1F1F5\":\"northern_mariana_islands\",\"1F1F3-1F1F4\":\"norway\",\"1F443\":\"nose\",\"1F4D3\":\"notebook\",\"1F4D4\":\"notebook_with_decorative_cover\",\"1F3B6\":\"notes\",\"1F529\":\"nut_and_bolt\",\"2B55\":\"o\",\"1F17E\":\"o2\",\"1F30A\":\"ocean\",\"1F419\":\"octopus\",\"1F362\":\"oden\",\"1F3E2\":\"office\",\"1F9D1-200D-1F4BC\":\"office_worker\",\"1F6E2\":\"oil_drum\",\"1F197\":\"ok\",\"1F44C\":\"ok_hand\",\"1F646-200D-2642-FE0F\":\"ok_man\",\"1F646\":\"ok_person\",\"1F646-200D-2640-FE0F\":\"ok_woman\",\"1F5DD\":\"old_key\",\"1F9D3\":\"older_adult\",\"1F474\":\"older_man\",\"1F475\":\"older_woman\",\"1FAD2\":\"olive\",\"1F549\":\"om\",\"1F1F4-1F1F2\":\"oman\",\"1F51B\":\"on\",\"1F698\":\"oncoming_automobile\",\"1F68D\":\"oncoming_bus\",\"1F694\":\"oncoming_police_car\",\"1F696\":\"oncoming_taxi\",\"0031-FE0F-20E3\":\"one\",\"1FA71\":\"one_piece_swimsuit\",\"1F9C5\":\"onion\",\"1F4C2\":\"open_file_folder\",\"1F450\":\"open_hands\",\"1F62E\":\"open_mouth\",\"26CE\":\"ophiuchus\",\"1F4D9\":\"orange_book\",\"1F7E0\":\"orange_circle\",\"1F9E1\":\"orange_heart\",\"1F7E7\":\"orange_square\",\"1F9A7\":\"orangutan\",\"1F9A6\":\"otter\",\"1F4E4\":\"outbox_tray\",\"1F989\":\"owl\",\"1F402\":\"ox\",\"1F9AA\":\"oyster\",\"1F4E6\":\"package\",\"1F4C4\":\"page_facing_up\",\"1F4C3\":\"page_with_curl\",\"1F4DF\":\"pager\",\"1F58C\":\"paintbrush\",\"1F1F5-1F1F0\":\"pakistan\",\"1F1F5-1F1FC\":\"palau\",\"1F1F5-1F1F8\":\"palestinian_territories\",\"1FAF3\":\"palm_down_hand\",\"1F334\":\"palm_tree\",\"1FAF4\":\"palm_up_hand\",\"1F932\":\"palms_up_together\",\"1F1F5-1F1E6\":\"panama\",\"1F95E\":\"pancakes\",\"1F43C\":\"panda_face\",\"1F4CE\":\"paperclip\",\"1F587\":\"paperclips\",\"1F1F5-1F1EC\":\"papua_new_guinea\",\"1FA82\":\"parachute\",\"1F1F5-1F1FE\":\"paraguay\",\"26F1\":\"parasol_on_ground\",\"1F17F\":\"parking\",\"1F99C\":\"parrot\",\"303D\":\"part_alternation_mark\",\"26C5\":\"partly_sunny\",\"1F973\":\"partying_face\",\"1F6F3\":\"passenger_ship\",\"1F6C2\":\"passport_control\",\"23F8\":\"pause_button\",\"1FADB\":\"pea_pod\",\"262E\":\"peace_symbol\",\"1F351\":\"peach\",\"1F99A\":\"peacock\",\"1F95C\":\"peanuts\",\"1F350\":\"pear\",\"1F58A\":\"pen\",\"270F\":\"pencil2\",\"1F427\":\"penguin\",\"1F614\":\"pensive\",\"1F9D1-200D-1F91D-200D-1F9D1\":\"people_holding_hands\",\"1FAC2\":\"people_hugging\",\"1F3AD\":\"performing_arts\",\"1F623\":\"persevere\",\"1F9D1-200D-1F9B2\":\"person_bald\",\"1F9D1-200D-1F9B1\":\"person_curly_hair\",\"1F9D1-200D-1F37C\":\"person_feeding_baby\",\"1F93A\":\"person_fencing\",\"1F9D1-200D-1F9BD\":\"person_in_manual_wheelchair\",\"1F9D1-200D-1F9BC\":\"person_in_motorized_wheelchair\",\"1F935\":\"person_in_tuxedo\",\"1F9D1-200D-1F9B0\":\"person_red_hair\",\"1F9D1-200D-1F9B3\":\"person_white_hair\",\"1FAC5\":\"person_with_crown\",\"1F9D1-200D-1F9AF\":\"person_with_probing_cane\",\"1F473\":\"person_with_turban\",\"1F470\":\"person_with_veil\",\"1F1F5-1F1EA\":\"peru\",\"1F9EB\":\"petri_dish\",\"1F1F5-1F1ED\":\"philippines\",\"260E\":[\"phone\",\"telephone\"],\"26CF\":\"pick\",\"1F6FB\":\"pickup_truck\",\"1F967\":\"pie\",\"1F437\":\"pig\",\"1F416\":\"pig2\",\"1F43D\":\"pig_nose\",\"1F48A\":\"pill\",\"1F9D1-200D-2708-FE0F\":\"pilot\",\"1FA85\":\"pinata\",\"1F90C\":\"pinched_fingers\",\"1F90F\":\"pinching_hand\",\"1F34D\":\"pineapple\",\"1F3D3\":\"ping_pong\",\"1FA77\":\"pink_heart\",\"1F3F4-200D-2620-FE0F\":\"pirate_flag\",\"1F1F5-1F1F3\":\"pitcairn_islands\",\"1F355\":\"pizza\",\"1FAA7\":\"placard\",\"1F6D0\":\"place_of_worship\",\"1F37D\":\"plate_with_cutlery\",\"23EF\":\"play_or_pause_button\",\"1F6DD\":\"playground_slide\",\"1F97A\":\"pleading_face\",\"1FAA0\":\"plunger\",\"1F447\":\"point_down\",\"1F448\":\"point_left\",\"1F449\":\"point_right\",\"261D\":\"point_up\",\"1F446\":\"point_up_2\",\"1F1F5-1F1F1\":\"poland\",\"1F43B-200D-2744-FE0F\":\"polar_bear\",\"1F693\":\"police_car\",\"1F46E-200D-2642-FE0F\":\"policeman\",\"1F46E-200D-2640-FE0F\":\"policewoman\",\"1F429\":\"poodle\",\"1F37F\":\"popcorn\",\"1F1F5-1F1F9\":\"portugal\",\"1F3E3\":\"post_office\",\"1F4EF\":\"postal_horn\",\"1F4EE\":\"postbox\",\"1F6B0\":\"potable_water\",\"1F954\":\"potato\",\"1FAB4\":\"potted_plant\",\"1F45D\":\"pouch\",\"1F357\":\"poultry_leg\",\"1F4B7\":\"pound\",\"1FAD7\":\"pouring_liquid\",\"1F621\":[\"pout\",\"rage\"],\"1F63E\":\"pouting_cat\",\"1F64E\":\"pouting_face\",\"1F64E-200D-2642-FE0F\":\"pouting_man\",\"1F64E-200D-2640-FE0F\":\"pouting_woman\",\"1F64F\":\"pray\",\"1F4FF\":\"prayer_beads\",\"1FAC3\":\"pregnant_man\",\"1FAC4\":\"pregnant_person\",\"1F930\":\"pregnant_woman\",\"1F968\":\"pretzel\",\"23EE\":\"previous_track_button\",\"1F934\":\"prince\",\"1F478\":\"princess\",\"1F5A8\":\"printer\",\"1F9AF\":\"probing_cane\",\"1F1F5-1F1F7\":\"puerto_rico\",\"1F7E3\":\"purple_circle\",\"1F49C\":\"purple_heart\",\"1F7EA\":\"purple_square\",\"1F45B\":\"purse\",\"1F4CC\":\"pushpin\",\"1F6AE\":\"put_litter_in_its_place\",\"1F1F6-1F1E6\":\"qatar\",\"1F430\":\"rabbit\",\"1F407\":\"rabbit2\",\"1F99D\":\"raccoon\",\"1F40E\":\"racehorse\",\"1F3CE\":\"racing_car\",\"1F4FB\":\"radio\",\"1F518\":\"radio_button\",\"1F683\":\"railway_car\",\"1F6E4\":\"railway_track\",\"1F308\":\"rainbow\",\"1F3F3-FE0F-200D-1F308\":\"rainbow_flag\",\"1F91A\":\"raised_back_of_hand\",\"1F928\":\"raised_eyebrow\",\"1F590\":\"raised_hand_with_fingers_splayed\",\"1F64C\":\"raised_hands\",\"1F64B\":\"raising_hand\",\"1F64B-200D-2642-FE0F\":\"raising_hand_man\",\"1F64B-200D-2640-FE0F\":\"raising_hand_woman\",\"1F40F\":\"ram\",\"1F35C\":\"ramen\",\"1F400\":\"rat\",\"1FA92\":\"razor\",\"1F9FE\":\"receipt\",\"23FA\":\"record_button\",\"267B\":\"recycle\",\"1F534\":\"red_circle\",\"1F9E7\":\"red_envelope\",\"1F468-200D-1F9B0\":\"red_haired_man\",\"1F469-200D-1F9B0\":\"red_haired_woman\",\"1F7E5\":\"red_square\",\"00AE\":\"registered\",\"263A\":\"relaxed\",\"1F60C\":\"relieved\",\"1F397\":\"reminder_ribbon\",\"1F501\":\"repeat\",\"1F502\":\"repeat_one\",\"26D1\":\"rescue_worker_helmet\",\"1F6BB\":\"restroom\",\"1F1F7-1F1EA\":\"reunion\",\"1F49E\":\"revolving_hearts\",\"23EA\":\"rewind\",\"1F98F\":\"rhinoceros\",\"1F380\":\"ribbon\",\"1F35A\":\"rice\",\"1F359\":\"rice_ball\",\"1F358\":\"rice_cracker\",\"1F391\":\"rice_scene\",\"1F5EF\":\"right_anger_bubble\",\"1FAF1\":\"rightwards_hand\",\"1FAF8\":\"rightwards_pushing_hand\",\"1F48D\":\"ring\",\"1F6DF\":\"ring_buoy\",\"1FA90\":\"ringed_planet\",\"1F916\":\"robot\",\"1FAA8\":\"rock\",\"1F680\":\"rocket\",\"1F923\":\"rofl\",\"1F644\":\"roll_eyes\",\"1F9FB\":\"roll_of_paper\",\"1F3A2\":\"roller_coaster\",\"1F6FC\":\"roller_skate\",\"1F1F7-1F1F4\":\"romania\",\"1F413\":\"rooster\",\"1F339\":\"rose\",\"1F3F5\":\"rosette\",\"1F6A8\":\"rotating_light\",\"1F4CD\":\"round_pushpin\",\"1F6A3\":\"rowboat\",\"1F6A3-200D-2642-FE0F\":\"rowing_man\",\"1F6A3-200D-2640-FE0F\":\"rowing_woman\",\"1F1F7-1F1FA\":\"ru\",\"1F3C9\":\"rugby_football\",\"1F3C3\":[\"runner\",\"running\"],\"1F3C3-200D-2642-FE0F\":\"running_man\",\"1F3BD\":\"running_shirt_with_sash\",\"1F3C3-200D-2640-FE0F\":\"running_woman\",\"1F1F7-1F1FC\":\"rwanda\",\"1F202\":\"sa\",\"1F9F7\":\"safety_pin\",\"1F9BA\":\"safety_vest\",\"1F376\":\"sake\",\"1F9C2\":\"salt\",\"1FAE1\":\"saluting_face\",\"1F1FC-1F1F8\":\"samoa\",\"1F1F8-1F1F2\":\"san_marino\",\"1F461\":\"sandal\",\"1F96A\":\"sandwich\",\"1F385\":\"santa\",\"1F1F8-1F1F9\":\"sao_tome_principe\",\"1F97B\":\"sari\",\"1F481-200D-2642-FE0F\":[\"sassy_man\",\"tipping_hand_man\"],\"1F481-200D-2640-FE0F\":[\"sassy_woman\",\"tipping_hand_woman\"],\"1F4E1\":\"satellite\",\"1F1F8-1F1E6\":\"saudi_arabia\",\"1F9D6-200D-2642-FE0F\":\"sauna_man\",\"1F9D6\":\"sauna_person\",\"1F9D6-200D-2640-FE0F\":\"sauna_woman\",\"1F995\":\"sauropod\",\"1F3B7\":\"saxophone\",\"1F9E3\":\"scarf\",\"1F3EB\":\"school\",\"1F392\":\"school_satchel\",\"1F9D1-200D-1F52C\":\"scientist\",\"1F982\":\"scorpion\",\"264F\":\"scorpius\",\"1F3F4-E0067-E0062-E0073-E0063-E0074-E007F\":\"scotland\",\"1F631\":\"scream\",\"1F640\":\"scream_cat\",\"1FA9B\":\"screwdriver\",\"1F4DC\":\"scroll\",\"1F9AD\":\"seal\",\"1F4BA\":\"seat\",\"1F648\":\"see_no_evil\",\"1F331\":\"seedling\",\"1F933\":\"selfie\",\"1F1F8-1F1F3\":\"senegal\",\"1F1F7-1F1F8\":\"serbia\",\"1F415-200D-1F9BA\":\"service_dog\",\"0037-FE0F-20E3\":\"seven\",\"1FAA1\":\"sewing_needle\",\"1F1F8-1F1E8\":\"seychelles\",\"1FAE8\":\"shaking_face\",\"1F958\":\"shallow_pan_of_food\",\"1F988\":\"shark\",\"1F367\":\"shaved_ice\",\"1F411\":\"sheep\",\"1F41A\":\"shell\",\"1F6E1\":\"shield\",\"26E9\":\"shinto_shrine\",\"1F6A2\":\"ship\",\"1F455\":[\"shirt\",\"tshirt\"],\"1F6CD\":\"shopping\",\"1F6D2\":\"shopping_cart\",\"1FA73\":\"shorts\",\"1F6BF\":\"shower\",\"1F990\":\"shrimp\",\"1F937\":\"shrug\",\"1F92B\":\"shushing_face\",\"1F1F8-1F1F1\":\"sierra_leone\",\"1F4F6\":\"signal_strength\",\"1F1F8-1F1EC\":\"singapore\",\"1F9D1-200D-1F3A4\":\"singer\",\"1F1F8-1F1FD\":\"sint_maarten\",\"0036-FE0F-20E3\":\"six\",\"1F52F\":\"six_pointed_star\",\"1F6F9\":\"skateboard\",\"1F3BF\":\"ski\",\"26F7\":\"skier\",\"1F480\":\"skull\",\"1F9A8\":\"skunk\",\"1F6F7\":\"sled\",\"1F634\":\"sleeping\",\"1F6CC\":\"sleeping_bed\",\"1F62A\":\"sleepy\",\"1F641\":\"slightly_frowning_face\",\"1F642\":\"slightly_smiling_face\",\"1F3B0\":\"slot_machine\",\"1F9A5\":\"sloth\",\"1F1F8-1F1F0\":\"slovakia\",\"1F1F8-1F1EE\":\"slovenia\",\"1F6E9\":\"small_airplane\",\"1F539\":\"small_blue_diamond\",\"1F538\":\"small_orange_diamond\",\"1F53A\":\"small_red_triangle\",\"1F53B\":\"small_red_triangle_down\",\"1F604\":\"smile\",\"1F638\":\"smile_cat\",\"1F603\":\"smiley\",\"1F63A\":\"smiley_cat\",\"1F972\":\"smiling_face_with_tear\",\"1F970\":\"smiling_face_with_three_hearts\",\"1F608\":\"smiling_imp\",\"1F60F\":\"smirk\",\"1F63C\":\"smirk_cat\",\"1F6AC\":\"smoking\",\"1F40C\":\"snail\",\"1F40D\":\"snake\",\"1F927\":\"sneezing_face\",\"1F3C2\":\"snowboarder\",\"26C4\":\"snowman\",\"1F9FC\":\"soap\",\"1F62D\":\"sob\",\"26BD\":\"soccer\",\"1F9E6\":\"socks\",\"1F94E\":\"softball\",\"1F1F8-1F1E7\":\"solomon_islands\",\"1F1F8-1F1F4\":\"somalia\",\"1F51C\":\"soon\",\"1F198\":\"sos\",\"1F509\":\"sound\",\"1F1FF-1F1E6\":\"south_africa\",\"1F1EC-1F1F8\":\"south_georgia_south_sandwich_islands\",\"1F1F8-1F1F8\":\"south_sudan\",\"1F47E\":\"space_invader\",\"1F35D\":\"spaghetti\",\"1F387\":\"sparkler\",\"1F496\":\"sparkling_heart\",\"1F64A\":\"speak_no_evil\",\"1F508\":\"speaker\",\"1F5E3\":\"speaking_head\",\"1F4AC\":\"speech_balloon\",\"1F6A4\":\"speedboat\",\"1F577\":\"spider\",\"1F578\":\"spider_web\",\"1F5D3\":\"spiral_calendar\",\"1F5D2\":\"spiral_notepad\",\"1F9FD\":\"sponge\",\"1F944\":\"spoon\",\"1F991\":\"squid\",\"1F1F1-1F1F0\":\"sri_lanka\",\"1F1E7-1F1F1\":\"st_barthelemy\",\"1F1F8-1F1ED\":\"st_helena\",\"1F1F0-1F1F3\":\"st_kitts_nevis\",\"1F1F1-1F1E8\":\"st_lucia\",\"1F1F2-1F1EB\":\"st_martin\",\"1F1F5-1F1F2\":\"st_pierre_miquelon\",\"1F1FB-1F1E8\":\"st_vincent_grenadines\",\"1F3DF\":\"stadium\",\"1F9CD-200D-2642-FE0F\":\"standing_man\",\"1F9CD\":\"standing_person\",\"1F9CD-200D-2640-FE0F\":\"standing_woman\",\"2B50\":\"star\",\"1F31F\":\"star2\",\"262A\":\"star_and_crescent\",\"1F929\":\"star_struck\",\"1F320\":\"stars\",\"1F689\":\"station\",\"1F5FD\":\"statue_of_liberty\",\"1F682\":\"steam_locomotive\",\"1FA7A\":\"stethoscope\",\"1F372\":\"stew\",\"23F9\":\"stop_button\",\"1F6D1\":\"stop_sign\",\"23F1\":\"stopwatch\",\"1F4CF\":\"straight_ruler\",\"1F353\":\"strawberry\",\"1F61B\":\"stuck_out_tongue\",\"1F61D\":\"stuck_out_tongue_closed_eyes\",\"1F61C\":\"stuck_out_tongue_winking_eye\",\"1F9D1-200D-1F393\":\"student\",\"1F399\":\"studio_microphone\",\"1F959\":\"stuffed_flatbread\",\"1F1F8-1F1E9\":\"sudan\",\"1F325\":\"sun_behind_large_cloud\",\"1F326\":\"sun_behind_rain_cloud\",\"1F324\":\"sun_behind_small_cloud\",\"1F31E\":\"sun_with_face\",\"1F33B\":\"sunflower\",\"1F60E\":\"sunglasses\",\"1F305\":\"sunrise\",\"1F304\":\"sunrise_over_mountains\",\"1F9B8\":\"superhero\",\"1F9B8-200D-2642-FE0F\":\"superhero_man\",\"1F9B8-200D-2640-FE0F\":\"superhero_woman\",\"1F9B9\":\"supervillain\",\"1F9B9-200D-2642-FE0F\":\"supervillain_man\",\"1F9B9-200D-2640-FE0F\":\"supervillain_woman\",\"1F3C4\":\"surfer\",\"1F3C4-200D-2642-FE0F\":\"surfing_man\",\"1F3C4-200D-2640-FE0F\":\"surfing_woman\",\"1F1F8-1F1F7\":\"suriname\",\"1F363\":\"sushi\",\"1F69F\":\"suspension_railway\",\"1F1F8-1F1EF\":\"svalbard_jan_mayen\",\"1F9A2\":\"swan\",\"1F1F8-1F1FF\":\"swaziland\",\"1F613\":\"sweat\",\"1F4A6\":\"sweat_drops\",\"1F605\":\"sweat_smile\",\"1F1F8-1F1EA\":\"sweden\",\"1F360\":\"sweet_potato\",\"1FA72\":\"swim_brief\",\"1F3CA\":\"swimmer\",\"1F3CA-200D-2642-FE0F\":\"swimming_man\",\"1F3CA-200D-2640-FE0F\":\"swimming_woman\",\"1F1E8-1F1ED\":\"switzerland\",\"1F523\":\"symbols\",\"1F54D\":\"synagogue\",\"1F1F8-1F1FE\":\"syria\",\"1F489\":\"syringe\",\"1F996\":\"t-rex\",\"1F32E\":\"taco\",\"1F389\":\"tada\",\"1F1F9-1F1FC\":\"taiwan\",\"1F1F9-1F1EF\":\"tajikistan\",\"1F961\":\"takeout_box\",\"1FAD4\":\"tamale\",\"1F38B\":\"tanabata_tree\",\"1F1F9-1F1FF\":\"tanzania\",\"1F695\":\"taxi\",\"1F375\":\"tea\",\"1F9D1-200D-1F3EB\":\"teacher\",\"1FAD6\":\"teapot\",\"1F9D1-200D-1F4BB\":\"technologist\",\"1F9F8\":\"teddy_bear\",\"1F4DE\":\"telephone_receiver\",\"1F52D\":\"telescope\",\"1F3BE\":\"tennis\",\"26FA\":\"tent\",\"1F9EA\":\"test_tube\",\"1F1F9-1F1ED\":\"thailand\",\"1F321\":\"thermometer\",\"1F914\":\"thinking\",\"1FA74\":\"thong_sandal\",\"1F4AD\":\"thought_balloon\",\"1F9F5\":\"thread\",\"0033-FE0F-20E3\":\"three\",\"1F3AB\":\"ticket\",\"1F39F\":\"tickets\",\"1F42F\":\"tiger\",\"1F405\":\"tiger2\",\"23F2\":\"timer_clock\",\"1F1F9-1F1F1\":\"timor_leste\",\"1F62B\":\"tired_face\",\"1F1F9-1F1EC\":\"togo\",\"1F6BD\":\"toilet\",\"1F1F9-1F1F0\":\"tokelau\",\"1F5FC\":\"tokyo_tower\",\"1F345\":\"tomato\",\"1F1F9-1F1F4\":\"tonga\",\"1F445\":\"tongue\",\"1F9F0\":\"toolbox\",\"1F9B7\":\"tooth\",\"1FAA5\":\"toothbrush\",\"1F51D\":\"top\",\"1F3A9\":\"tophat\",\"1F32A\":\"tornado\",\"1F1F9-1F1F7\":\"tr\",\"1F5B2\":\"trackball\",\"1F69C\":\"tractor\",\"1F6A5\":\"traffic_light\",\"1F68B\":\"train\",\"1F686\":\"train2\",\"1F68A\":\"tram\",\"1F3F3-FE0F-200D-26A7-FE0F\":\"transgender_flag\",\"26A7\":\"transgender_symbol\",\"1F6A9\":\"triangular_flag_on_post\",\"1F4D0\":\"triangular_ruler\",\"1F531\":\"trident\",\"1F1F9-1F1F9\":\"trinidad_tobago\",\"1F1F9-1F1E6\":\"tristan_da_cunha\",\"1F624\":\"triumph\",\"1F9CC\":\"troll\",\"1F68E\":\"trolleybus\",\"1F3C6\":\"trophy\",\"1F379\":\"tropical_drink\",\"1F420\":\"tropical_fish\",\"1F69A\":\"truck\",\"1F3BA\":\"trumpet\",\"1F337\":\"tulip\",\"1F943\":\"tumbler_glass\",\"1F1F9-1F1F3\":\"tunisia\",\"1F983\":\"turkey\",\"1F1F9-1F1F2\":\"turkmenistan\",\"1F1F9-1F1E8\":\"turks_caicos_islands\",\"1F422\":\"turtle\",\"1F1F9-1F1FB\":\"tuvalu\",\"1F4FA\":\"tv\",\"1F500\":\"twisted_rightwards_arrows\",\"0032-FE0F-20E3\":\"two\",\"1F495\":\"two_hearts\",\"1F46C\":\"two_men_holding_hands\",\"1F46D\":\"two_women_holding_hands\",\"1F239\":\"u5272\",\"1F234\":\"u5408\",\"1F23A\":\"u55b6\",\"1F22F\":\"u6307\",\"1F237\":\"u6708\",\"1F236\":\"u6709\",\"1F235\":\"u6e80\",\"1F21A\":\"u7121\",\"1F238\":\"u7533\",\"1F232\":\"u7981\",\"1F233\":\"u7a7a\",\"1F1FA-1F1EC\":\"uganda\",\"1F1FA-1F1E6\":\"ukraine\",\"1F612\":\"unamused\",\"1F51E\":\"underage\",\"1F984\":\"unicorn\",\"1F1E6-1F1EA\":\"united_arab_emirates\",\"1F1FA-1F1F3\":\"united_nations\",\"1F513\":\"unlock\",\"1F199\":\"up\",\"1F643\":\"upside_down_face\",\"1F1FA-1F1FE\":\"uruguay\",\"1F1FA-1F1F8\":\"us\",\"1F1FA-1F1F2\":\"us_outlying_islands\",\"1F1FB-1F1EE\":\"us_virgin_islands\",\"1F1FA-1F1FF\":\"uzbekistan\",\"270C\":\"v\",\"1F9DB\":\"vampire\",\"1F9DB-200D-2642-FE0F\":\"vampire_man\",\"1F9DB-200D-2640-FE0F\":\"vampire_woman\",\"1F1FB-1F1FA\":\"vanuatu\",\"1F1FB-1F1E6\":\"vatican_city\",\"1F1FB-1F1EA\":\"venezuela\",\"1F6A6\":\"vertical_traffic_light\",\"1F4FC\":\"vhs\",\"1F4F3\":\"vibration_mode\",\"1F4F9\":\"video_camera\",\"1F3AE\":\"video_game\",\"1F1FB-1F1F3\":\"vietnam\",\"1F3BB\":\"violin\",\"264D\":\"virgo\",\"1F30B\":\"volcano\",\"1F3D0\":\"volleyball\",\"1F92E\":\"vomiting_face\",\"1F19A\":\"vs\",\"1F596\":\"vulcan_salute\",\"1F9C7\":\"waffle\",\"1F3F4-E0067-E0062-E0077-E006C-E0073-E007F\":\"wales\",\"1F6B6\":\"walking\",\"1F6B6-200D-2642-FE0F\":\"walking_man\",\"1F6B6-200D-2640-FE0F\":\"walking_woman\",\"1F1FC-1F1EB\":\"wallis_futuna\",\"1F318\":\"waning_crescent_moon\",\"1F316\":\"waning_gibbous_moon\",\"26A0\":\"warning\",\"1F5D1\":\"wastebasket\",\"231A\":\"watch\",\"1F403\":\"water_buffalo\",\"1F93D\":\"water_polo\",\"1F349\":\"watermelon\",\"1F44B\":\"wave\",\"1F312\":\"waxing_crescent_moon\",\"1F6BE\":\"wc\",\"1F629\":\"weary\",\"1F492\":\"wedding\",\"1F3CB\":\"weight_lifting\",\"1F3CB-FE0F-200D-2642-FE0F\":\"weight_lifting_man\",\"1F3CB-FE0F-200D-2640-FE0F\":\"weight_lifting_woman\",\"1F1EA-1F1ED\":\"western_sahara\",\"1F433\":\"whale\",\"1F40B\":\"whale2\",\"1F6DE\":\"wheel\",\"267F\":\"wheelchair\",\"26AA\":\"white_circle\",\"1F3F3\":\"white_flag\",\"1F4AE\":\"white_flower\",\"1F468-200D-1F9B3\":\"white_haired_man\",\"1F469-200D-1F9B3\":\"white_haired_woman\",\"1F90D\":\"white_heart\",\"2B1C\":\"white_large_square\",\"25FD\":\"white_medium_small_square\",\"25FB\":\"white_medium_square\",\"25AB\":\"white_small_square\",\"1F533\":\"white_square_button\",\"1F940\":\"wilted_flower\",\"1F390\":\"wind_chime\",\"1F32C\":\"wind_face\",\"1FA9F\":\"window\",\"1F377\":\"wine_glass\",\"1FABD\":\"wing\",\"1F609\":\"wink\",\"1F6DC\":\"wireless\",\"1F43A\":\"wolf\",\"1F469\":\"woman\",\"1F469-200D-1F3A8\":\"woman_artist\",\"1F469-200D-1F680\":\"woman_astronaut\",\"1F9D4-200D-2640-FE0F\":\"woman_beard\",\"1F938-200D-2640-FE0F\":\"woman_cartwheeling\",\"1F469-200D-1F373\":\"woman_cook\",\"1F926-200D-2640-FE0F\":\"woman_facepalming\",\"1F469-200D-1F3ED\":\"woman_factory_worker\",\"1F469-200D-1F33E\":\"woman_farmer\",\"1F469-200D-1F37C\":\"woman_feeding_baby\",\"1F469-200D-1F692\":\"woman_firefighter\",\"1F469-200D-2695-FE0F\":\"woman_health_worker\",\"1F469-200D-1F9BD\":\"woman_in_manual_wheelchair\",\"1F469-200D-1F9BC\":\"woman_in_motorized_wheelchair\",\"1F935-200D-2640-FE0F\":\"woman_in_tuxedo\",\"1F469-200D-2696-FE0F\":\"woman_judge\",\"1F939-200D-2640-FE0F\":\"woman_juggling\",\"1F469-200D-1F527\":\"woman_mechanic\",\"1F469-200D-1F4BC\":\"woman_office_worker\",\"1F469-200D-2708-FE0F\":\"woman_pilot\",\"1F93E-200D-2640-FE0F\":\"woman_playing_handball\",\"1F93D-200D-2640-FE0F\":\"woman_playing_water_polo\",\"1F469-200D-1F52C\":\"woman_scientist\",\"1F937-200D-2640-FE0F\":\"woman_shrugging\",\"1F469-200D-1F3A4\":\"woman_singer\",\"1F469-200D-1F393\":\"woman_student\",\"1F469-200D-1F3EB\":\"woman_teacher\",\"1F469-200D-1F4BB\":\"woman_technologist\",\"1F9D5\":\"woman_with_headscarf\",\"1F469-200D-1F9AF\":\"woman_with_probing_cane\",\"1F473-200D-2640-FE0F\":\"woman_with_turban\",\"1F45A\":\"womans_clothes\",\"1F452\":\"womans_hat\",\"1F93C-200D-2640-FE0F\":\"women_wrestling\",\"1F6BA\":\"womens\",\"1FAB5\":\"wood\",\"1F974\":\"woozy_face\",\"1F5FA\":\"world_map\",\"1FAB1\":\"worm\",\"1F61F\":\"worried\",\"1F527\":\"wrench\",\"1F93C\":\"wrestling\",\"270D\":\"writing_hand\",\"274C\":\"x\",\"1FA7B\":\"x_ray\",\"1F9F6\":\"yarn\",\"1F971\":\"yawning_face\",\"1F7E1\":\"yellow_circle\",\"1F49B\":\"yellow_heart\",\"1F7E8\":\"yellow_square\",\"1F1FE-1F1EA\":\"yemen\",\"1F4B4\":\"yen\",\"262F\":\"yin_yang\",\"1FA80\":\"yo_yo\",\"1F60B\":\"yum\",\"1F1FF-1F1F2\":\"zambia\",\"1F92A\":\"zany_face\",\"26A1\":\"zap\",\"1F993\":\"zebra\",\"0030-FE0F-20E3\":\"zero\",\"1F1FF-1F1FC\":\"zimbabwe\",\"1F910\":\"zipper_mouth_face\",\"1F9DF\":\"zombie\",\"1F9DF-200D-2642-FE0F\":\"zombie_man\",\"1F9DF-200D-2640-FE0F\":\"zombie_woman\",\"1F4A4\":\"zzz\"}");
exports.default = data;
//# sourceMappingURL=data-files.generated.js.map