"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.options = void 0;
exports.validateConfigSecretsAndVariables = validateConfigSecretsAndVariables;
exports.applySecretsAndVariablesToConfig = applySecretsAndVariablesToConfig;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const interpolator_1 = require("../util/interpolator");
const regex_1 = require("../util/regex");
const sanitize_1 = require("../util/sanitize");
const namePattern = '[A-Za-z][A-Za-z0-9_]*';
const nameRegex = (0, regex_1.regEx)(`^${namePattern}$`);
const secretTemplateRegex = (0, regex_1.regEx)(`{{ secrets\\.(${namePattern}) }}`);
const variableTemplateRegex = (0, regex_1.regEx)(`{{ variables\\.(${namePattern}) }}`);
exports.options = {
    secrets: {
        name: 'secrets',
        nameRegex,
        templateRegex: secretTemplateRegex,
    },
    variables: {
        name: 'variables',
        nameRegex,
        templateRegex: variableTemplateRegex,
    },
};
function validateNestedInterpolatedValues(config, key) {
    (0, interpolator_1.validateInterpolatedValues)(config[key], exports.options[key]);
    if (config.repositories) {
        for (const repository of config.repositories) {
            if (is_1.default.plainObject(repository)) {
                (0, interpolator_1.validateInterpolatedValues)(repository[key], exports.options[key]);
            }
        }
    }
}
function validateConfigSecretsAndVariables(config) {
    validateNestedInterpolatedValues(config, 'secrets');
    validateNestedInterpolatedValues(config, 'variables');
}
/**
 * Applies both variables and secrets to the Renovate config by interpolating values
 */
function applySecretsAndVariablesToConfig(applyConfig) {
    const { config, deleteSecrets, deleteVariables } = applyConfig;
    const secrets = applyConfig.secrets ?? config.secrets;
    const variables = applyConfig.variables ?? config.variables;
    // Add all secrets to be sanitized
    if (is_1.default.plainObject(secrets)) {
        for (const secret of Object.values(secrets)) {
            (0, sanitize_1.addSecretForSanitizing)(secret);
        }
    }
    const configWithVars = (0, interpolator_1.replaceInterpolatedValuesInObject)(config, variables ?? {}, exports.options.variables, deleteVariables);
    return (0, interpolator_1.replaceInterpolatedValuesInObject)(configWithVars, secrets ?? {}, exports.options.secrets, deleteSecrets);
}
//# sourceMappingURL=secrets.js.map