import type { InterpolatorOptions } from '../util/interpolator';
import type { RenovateConfig } from './types';
export declare const options: Record<'secrets' | 'variables', InterpolatorOptions>;
export declare function validateConfigSecretsAndVariables(config: RenovateConfig): void;
interface ApplySecretsAndVariablesConfig {
    config: RenovateConfig;
    secrets?: RenovateConfig['secrets'];
    variables?: RenovateConfig['variables'];
    deleteSecrets?: boolean;
    deleteVariables?: boolean;
}
/**
 * Applies both variables and secrets to the Renovate config by interpolating values
 */
export declare function applySecretsAndVariablesToConfig(applyConfig: ApplySecretsAndVariablesConfig): RenovateConfig;
export {};
