"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPreset = getPreset;
const logger_1 = require("../../../logger");
const npmrc_1 = require("../../../modules/datasource/npm/npmrc");
const http_1 = require("../../../util/http");
const memory_http_cache_provider_1 = require("../../../util/http/cache/memory-http-cache-provider");
const util_1 = require("../util");
const id = 'npm';
const http = new http_1.Http(id);
async function getPreset({ repo: pkg, presetName = 'default', }) {
    let dep;
    try {
        const registryUrl = (0, npmrc_1.resolveRegistryUrl)(pkg);
        logger_1.logger.once.warn({ registryUrl, pkg }, 'Using npm packages for Renovate presets is now deprecated. Please migrate to repository-based presets instead.');
        const packageUrl = (0, npmrc_1.resolvePackageUrl)(registryUrl, pkg);
        const body = (await http.getJsonUnchecked(packageUrl, {
            cacheProvider: memory_http_cache_provider_1.memCacheProvider,
        })).body;
        // TODO: check null #22198
        dep = body.versions[body['dist-tags'].latest];
    }
    catch {
        throw new Error(util_1.PRESET_DEP_NOT_FOUND);
    }
    if (!dep?.['renovate-config']) {
        throw new Error(util_1.PRESET_RENOVATE_CONFIG_NOT_FOUND);
    }
    const presetConfig = dep['renovate-config'][presetName];
    if (!presetConfig) {
        const presetNames = Object.keys(dep['renovate-config']);
        logger_1.logger.debug({ presetNames, presetName }, 'Preset not found within renovate-config');
        throw new Error(util_1.PRESET_NOT_FOUND);
    }
    return presetConfig;
}
//# sourceMappingURL=index.js.map