"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.presets = void 0;
exports.presets = {
    'openssf-scorecard': {
        description: 'Show OpenSSF badge on pull requests.',
        packageRules: [
            {
                matchSourceUrls: ['https://github.com/**'],
                prBodyDefinitions: {
                    OpenSSF: '[![OpenSSF Scorecard](https://api.securityscorecards.dev/projects/github.com/{{sourceRepo}}/badge)](https://securityscorecards.dev/viewer/?uri=github.com/{{sourceRepo}})',
                },
                prBodyColumns: [
                    'Package',
                    'Type',
                    'Update',
                    'Change',
                    'Pending',
                    'OpenSSF',
                ],
            },
        ],
    },
    'only-security-updates': {
        description: 'Only update dependencies if vulnerabilities have been detected.',
        extends: ['config:recommended'],
        packageRules: [
            {
                enabled: false,
                matchPackageNames: ['*'],
            },
        ],
        vulnerabilityAlerts: {
            enabled: true,
        },
        osvVulnerabilityAlerts: true,
    },
};
//# sourceMappingURL=security.js.map