"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.presets = exports.supportedDatasources = void 0;
exports.supportedDatasources = [
    'go',
    'maven',
    'npm',
    'nuget',
    'packagist',
    'pypi',
    'rubygems',
];
exports.presets = {
    'all-badges': {
        description: 'Show all Merge Confidence badges for pull requests.',
        packageRules: [
            {
                matchDatasources: exports.supportedDatasources,
                matchUpdateTypes: ['patch', 'minor', 'major'],
                prBodyColumns: [
                    'Package',
                    'Change',
                    'Age',
                    'Adoption',
                    'Passing',
                    'Confidence',
                ],
            },
        ],
    },
    'age-confidence-badges': {
        description: 'Show only the Age and Confidence Merge Confidence badges for pull requests.',
        packageRules: [
            {
                matchDatasources: exports.supportedDatasources,
                matchUpdateTypes: ['patch', 'minor', 'major'],
                prBodyColumns: ['Package', 'Change', 'Age', 'Confidence'],
            },
        ],
    },
};
//# sourceMappingURL=merge-confidence.js.map