"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.groups = void 0;
exports.getPreset = getPreset;
const tslib_1 = require("tslib");
const configAbandonments = tslib_1.__importStar(require("./abandonments"));
const configPreset = tslib_1.__importStar(require("./config"));
const customManagersPreset = tslib_1.__importStar(require("./custom-managers"));
const defaultPreset = tslib_1.__importStar(require("./default"));
const dockerPreset = tslib_1.__importStar(require("./docker"));
const globalPreset = tslib_1.__importStar(require("./global"));
const groupPreset = tslib_1.__importStar(require("./group"));
const helpersPreset = tslib_1.__importStar(require("./helpers"));
const mergeConfidence = tslib_1.__importStar(require("./merge-confidence"));
const monorepoPreset = tslib_1.__importStar(require("./monorepos"));
const npm = tslib_1.__importStar(require("./npm"));
const packagesPreset = tslib_1.__importStar(require("./packages"));
const previewPreset = tslib_1.__importStar(require("./preview"));
const replacements = tslib_1.__importStar(require("./replacements"));
const schedulePreset = tslib_1.__importStar(require("./schedule"));
const securityPreset = tslib_1.__importStar(require("./security"));
const workaroundsPreset = tslib_1.__importStar(require("./workarounds"));
/* eslint sort-keys: ["error", "asc", {caseSensitive: false, natural: true}] */
exports.groups = {
    abandonments: configAbandonments.presets,
    config: configPreset.presets,
    customManagers: customManagersPreset.presets,
    default: defaultPreset.presets,
    docker: dockerPreset.presets,
    global: globalPreset.presets,
    group: groupPreset.presets,
    helpers: helpersPreset.presets,
    mergeConfidence: mergeConfidence.presets,
    monorepo: monorepoPreset.presets,
    npm: npm.presets,
    packages: packagesPreset.presets,
    preview: previewPreset.presets,
    replacements: replacements.presets,
    schedule: schedulePreset.presets,
    security: securityPreset.presets,
    workarounds: workaroundsPreset.presets,
};
function getPreset({ repo, presetName, }) {
    return exports.groups[repo] && presetName ? exports.groups[repo][presetName] : undefined;
}
//# sourceMappingURL=index.js.map