"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addPresets = addPresets;
const array_1 = require("../../../util/array");
function generatePackageRules(replacementRules) {
    const rules = [];
    for (const replacementRule of replacementRules) {
        const { matchCurrentVersion, matchDatasources, replacements, replacementVersion, } = replacementRule;
        for (const replacement of replacements) {
            const [matchPackageNames, replacementName] = replacement;
            rules.push({
                matchCurrentVersion,
                matchDatasources,
                matchPackageNames,
                replacementName,
                replacementVersion,
            });
        }
    }
    return rules;
}
function addPresets(presets, ...templates) {
    const ext = (0, array_1.coerceArray)(presets.all?.extends);
    for (const template of templates) {
        const { title, description, packageRules } = template;
        presets[title] = {
            description,
            packageRules: generatePackageRules(packageRules),
        };
        ext.push(`replacements:${title}`);
    }
    ext.sort();
}
//# sourceMappingURL=auto-generate-replacements.js.map