"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPreset = getPreset;
const logger_1 = require("../../../logger");
const external_host_error_1 = require("../../../types/errors/external-host-error");
const http_1 = require("../../../util/http");
const memory_http_cache_provider_1 = require("../../../util/http/cache/memory-http-cache-provider");
const url_1 = require("../../../util/url");
const util_1 = require("../util");
const http = new http_1.Http('preset');
async function getPreset({ repo: url, }) {
    const parsedUrl = (0, url_1.parseUrl)(url);
    let response;
    if (!parsedUrl) {
        logger_1.logger.debug(`Preset URL ${url} is malformed`);
        throw new Error(util_1.PRESET_DEP_NOT_FOUND);
    }
    try {
        response = await http.getText(url, { cacheProvider: memory_http_cache_provider_1.memCacheProvider });
    }
    catch (err) {
        if (err instanceof external_host_error_1.ExternalHostError) {
            throw err;
        }
        logger_1.logger.debug(`Preset file ${url} not found`);
        throw new Error(util_1.PRESET_DEP_NOT_FOUND);
    }
    return (0, util_1.parsePreset)(response.body, parsedUrl.pathname);
}
//# sourceMappingURL=index.js.map