"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MigrationsService = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const dequal_1 = require("dequal");
const remove_property_migration_1 = require("./base/remove-property-migration");
const rename_property_migration_1 = require("./base/rename-property-migration");
const automerge_major_migration_1 = require("./custom/automerge-major-migration");
const automerge_migration_1 = require("./custom/automerge-migration");
const automerge_minor_migration_1 = require("./custom/automerge-minor-migration");
const automerge_patch_migration_1 = require("./custom/automerge-patch-migration");
const automerge_type_migration_1 = require("./custom/automerge-type-migration");
const azure_gitlab_automerge_migration_1 = require("./custom/azure-gitlab-automerge-migration");
const base_branch_migration_1 = require("./custom/base-branch-migration");
const binary_source_migration_1 = require("./custom/binary-source-migration");
const branch_name_migration_1 = require("./custom/branch-name-migration");
const branch_prefix_migration_1 = require("./custom/branch-prefix-migration");
const compatibility_migration_1 = require("./custom/compatibility-migration");
const composer_ignore_platform_reqs_migration_1 = require("./custom/composer-ignore-platform-reqs-migration");
const custom_managers_migration_1 = require("./custom/custom-managers-migration");
const datasource_migration_1 = require("./custom/datasource-migration");
const dep_types_migration_1 = require("./custom/dep-types-migration");
const dry_run_migration_1 = require("./custom/dry-run-migration");
const enabled_managers_migration_1 = require("./custom/enabled-managers-migration");
const extends_migration_1 = require("./custom/extends-migration");
const fetch_release_notes_migration_1 = require("./custom/fetch-release-notes-migration");
const file_match_migration_1 = require("./custom/file-match-migration");
const go_mod_tidy_migration_1 = require("./custom/go-mod-tidy-migration");
const host_rules_migration_1 = require("./custom/host-rules-migration");
const ignore_node_modules_migration_1 = require("./custom/ignore-node-modules-migration");
const ignore_npmrc_file_migration_1 = require("./custom/ignore-npmrc-file-migration");
const include_forks_migration_1 = require("./custom/include-forks-migration");
const match_datasources_migration_1 = require("./custom/match-datasources-migration");
const match_managers_migration_1 = require("./custom/match-managers-migration");
const match_strings_migration_1 = require("./custom/match-strings-migration");
const node_migration_1 = require("./custom/node-migration");
const package_files_migration_1 = require("./custom/package-files-migration");
const package_name_migration_1 = require("./custom/package-name-migration");
const package_pattern_migration_1 = require("./custom/package-pattern-migration");
const package_rules_migration_1 = require("./custom/package-rules-migration");
const packages_migration_1 = require("./custom/packages-migration");
const path_rules_migration_1 = require("./custom/path-rules-migration");
const pin_versions_migration_1 = require("./custom/pin-versions-migration");
const platform_commit_migration_1 = require("./custom/platform-commit-migration");
const post_update_options_migration_1 = require("./custom/post-update-options-migration");
const rebase_conflicted_prs_migration_1 = require("./custom/rebase-conflicted-prs-migration");
const rebase_stale_prs_migration_1 = require("./custom/rebase-stale-prs-migration");
const recreate_closed_migration_1 = require("./custom/recreate-closed-migration");
const renovate_fork_migration_1 = require("./custom/renovate-fork-migration");
const require_config_migration_1 = require("./custom/require-config-migration");
const required_status_checks_migration_1 = require("./custom/required-status-checks-migration");
const schedule_migration_1 = require("./custom/schedule-migration");
const semantic_commits_migration_1 = require("./custom/semantic-commits-migration");
const semantic_prefix_migration_1 = require("./custom/semantic-prefix-migration");
const separate_major_release_migration_1 = require("./custom/separate-major-release-migration");
const separate_multiple_major_migration_1 = require("./custom/separate-multiple-major-migration");
const stability_days_migration_1 = require("./custom/stability-days-migration");
const suppress_notifications_migration_1 = require("./custom/suppress-notifications-migration");
const trust_level_migration_1 = require("./custom/trust-level-migration");
const unpublish_safe_migration_1 = require("./custom/unpublish-safe-migration");
const upgrade_in_range_migration_1 = require("./custom/upgrade-in-range-migration");
const version_strategy_migration_1 = require("./custom/version-strategy-migration");
class MigrationsService {
    static removedProperties = new Set([
        'allowCommandTemplating',
        'allowPostUpgradeCommandTemplating',
        'deepExtract',
        'gitFs',
        'groupBranchName',
        'groupCommitMessage',
        'groupPrBody',
        'groupPrTitle',
        'lazyGrouping',
        'maintainYarnLock',
        'raiseDeprecationWarnings',
        'statusCheckVerify',
        'supportPolicy',
        'transitiveRemediation',
        'yarnCacheFolder',
        'yarnMaintenanceBranchName',
        'yarnMaintenanceCommitMessage',
        'yarnMaintenancePrBody',
        'yarnMaintenancePrTitle',
    ]);
    static renamedProperties = new Map([
        ['adoptium-java', 'java-version'],
        ['allowedPostUpgradeCommands', 'allowedCommands'],
        ['azureAutoApprove', 'autoApprove'],
        ['customChangelogUrl', 'changelogUrl'],
        ['endpoints', 'hostRules'],
        ['excludedPackageNames', 'excludePackageNames'],
        ['exposeEnv', 'exposeAllEnv'],
        ['keepalive', 'keepAlive'],
        ['managerBranchPrefix', 'additionalBranchPrefix'],
        ['multipleMajorPrs', 'separateMultipleMajor'],
        ['separatePatchReleases', 'separateMinorPatch'],
        ['versionScheme', 'versioning'],
        ['lookupNameTemplate', 'packageNameTemplate'],
        ['aliases', 'registryAliases'],
        ['masterIssue', 'dependencyDashboard'],
        ['masterIssueApproval', 'dependencyDashboardApproval'],
        ['masterIssueAutoclose', 'dependencyDashboardAutoclose'],
        ['masterIssueHeader', 'dependencyDashboardHeader'],
        ['masterIssueFooter', 'dependencyDashboardFooter'],
        ['masterIssueTitle', 'dependencyDashboardTitle'],
        ['masterIssueLabels', 'dependencyDashboardLabels'],
        ['regexManagers', 'customManagers'],
    ]);
    static customMigrations = [
        automerge_major_migration_1.AutomergeMajorMigration,
        automerge_migration_1.AutomergeMigration,
        automerge_minor_migration_1.AutomergeMinorMigration,
        automerge_patch_migration_1.AutomergePatchMigration,
        automerge_type_migration_1.AutomergeTypeMigration,
        azure_gitlab_automerge_migration_1.AzureGitLabAutomergeMigration,
        base_branch_migration_1.BaseBranchMigration,
        binary_source_migration_1.BinarySourceMigration,
        branch_name_migration_1.BranchNameMigration,
        branch_prefix_migration_1.BranchPrefixMigration,
        compatibility_migration_1.CompatibilityMigration,
        composer_ignore_platform_reqs_migration_1.ComposerIgnorePlatformReqsMigration,
        enabled_managers_migration_1.EnabledManagersMigration,
        extends_migration_1.ExtendsMigration,
        go_mod_tidy_migration_1.GoModTidyMigration,
        host_rules_migration_1.HostRulesMigration,
        ignore_node_modules_migration_1.IgnoreNodeModulesMigration,
        ignore_npmrc_file_migration_1.IgnoreNpmrcFileMigration,
        include_forks_migration_1.IncludeForksMigration,
        match_strings_migration_1.MatchStringsMigration,
        package_name_migration_1.PackageNameMigration,
        package_pattern_migration_1.PackagePatternMigration,
        packages_migration_1.PackagesMigration,
        path_rules_migration_1.PathRulesMigration,
        pin_versions_migration_1.PinVersionsMigration,
        post_update_options_migration_1.PostUpdateOptionsMigration,
        rebase_conflicted_prs_migration_1.RebaseConflictedPrs,
        rebase_stale_prs_migration_1.RebaseStalePrsMigration,
        renovate_fork_migration_1.RenovateForkMigration,
        required_status_checks_migration_1.RequiredStatusChecksMigration,
        schedule_migration_1.ScheduleMigration,
        semantic_commits_migration_1.SemanticCommitsMigration,
        separate_major_release_migration_1.SeparateMajorReleasesMigration,
        separate_multiple_major_migration_1.SeparateMultipleMajorMigration,
        suppress_notifications_migration_1.SuppressNotificationsMigration,
        trust_level_migration_1.TrustLevelMigration,
        unpublish_safe_migration_1.UnpublishSafeMigration,
        upgrade_in_range_migration_1.UpgradeInRangeMigration,
        version_strategy_migration_1.VersionStrategyMigration,
        dry_run_migration_1.DryRunMigration,
        require_config_migration_1.RequireConfigMigration,
        package_files_migration_1.PackageFilesMigration,
        dep_types_migration_1.DepTypesMigration,
        package_rules_migration_1.PackageRulesMigration,
        node_migration_1.NodeMigration,
        semantic_prefix_migration_1.SemanticPrefixMigration,
        match_datasources_migration_1.MatchDatasourcesMigration,
        datasource_migration_1.DatasourceMigration,
        recreate_closed_migration_1.RecreateClosedMigration,
        stability_days_migration_1.StabilityDaysMigration,
        fetch_release_notes_migration_1.FetchReleaseNotesMigration,
        match_managers_migration_1.MatchManagersMigration,
        custom_managers_migration_1.CustomManagersMigration,
        platform_commit_migration_1.PlatformCommitMigration,
        file_match_migration_1.FileMatchMigration,
    ];
    static run(originalConfig, parentKey) {
        const migratedConfig = {};
        const migrations = this.getMigrations(originalConfig, migratedConfig);
        for (const [key, value] of Object.entries(originalConfig)) {
            migratedConfig[key] ??= value;
            const migration = MigrationsService.getMigration(migrations, key);
            if (migration) {
                migration.run(value, key, parentKey);
                if (migration.deprecated) {
                    delete migratedConfig[key];
                }
            }
        }
        return migratedConfig;
    }
    static isMigrated(originalConfig, migratedConfig) {
        return !(0, dequal_1.dequal)(originalConfig, migratedConfig);
    }
    static getMigrations(originalConfig, migratedConfig) {
        const migrations = [];
        for (const propertyName of MigrationsService.removedProperties) {
            migrations.push(new remove_property_migration_1.RemovePropertyMigration(propertyName, originalConfig, migratedConfig));
        }
        for (const [oldPropertyName, newPropertyName,] of MigrationsService.renamedProperties.entries()) {
            migrations.push(new rename_property_migration_1.RenamePropertyMigration(oldPropertyName, newPropertyName, originalConfig, migratedConfig));
        }
        for (const CustomMigration of this.customMigrations) {
            migrations.push(new CustomMigration(originalConfig, migratedConfig));
        }
        return migrations;
    }
    static getMigration(migrations, key) {
        return migrations.find((migration) => {
            if (is_1.default.regExp(migration.propertyName)) {
                return migration.propertyName.test(key);
            }
            return migration.propertyName === key;
        });
    }
}
exports.MigrationsService = MigrationsService;
//# sourceMappingURL=migrations-service.js.map