import type { RenovateConfig } from '../types';
import type { Migration, MigrationConstructor } from './types';
export declare class MigrationsService {
    static readonly removedProperties: ReadonlySet<string>;
    static readonly renamedProperties: ReadonlyMap<string, string>;
    static readonly customMigrations: readonly MigrationConstructor[];
    static run(originalConfig: RenovateConfig, parentKey?: string): RenovateConfig;
    static isMigrated(originalConfig: RenovateConfig, migratedConfig: RenovateConfig): boolean;
    static getMigrations(originalConfig: RenovateConfig, migratedConfig: RenovateConfig): readonly Migration[];
    private static getMigration;
}
